##
#	$Id: kyoku.rb 69 2009-03-09 18:29:47Z yatsuhashi $
#
module OpenMjServer
  class Kyoku
    class ExitPhase < Exception; end

    #
    def initialize(game)
      @game = game
      @yama = game.yama
      @taku = game.taku.dup
      @bakaze = game.bakaze
      @tsumi = game.tsumi
      @kyotaku = game.kyotaku
      @dora = Mahjong::HaiArray.new
      @phase = :TSUMO
      @sutehai = nil
      set_turn(0)
      play
    end

    private

    #
    def play
      @taku.send('kyokustart', @bakaze, @taku[0], @tsumi, @kyotaku)
      @taku.each { |player|
        @taku.send('point', player.to_s, "=#{player.point}")
      }

      if $config[:wanpai] > Mahjong::Yama::WANPAI
        @yama.drop($config[:wanpai] - Mahjong::Yama::WANPAI)
      end

      dice
      $config[:dora].times { add_dora }
      haipai

      while @phase != :END
        begin
          case @phase
          when :TSUMO
            if @yama.rest == 0
              ryukyoku
            else
              phase_tsumo
            end
          when :SUTEHAI
            phase_sutehai
          when :NAKI
            phase_naki
          end
        rescue ExitPhase
        end
      end

      @taku.send('kyokuend')
      @taku.each { |player| player.send('ready?').recv }
    end

    # サイコロを振る(意味はない)
    def dice
      @taku.send('dice', (rand(6) + 1).to_s, (rand(6) + 1).to_s)
    end

    # ドラをめくる
    def add_dora
      hai = @yama.dora
      @taku.send('dora', hai.to_s)
      @dora << hai.succ
    end

    # 配牌
    def haipai
      kaze = Mahjong::Hai['1z']
      @taku.each { |player|
        hais = @yama.haipai
        player.haipai(hais, @bakaze, kaze)
        if $config[:fullopen]
          @taku.send('haipai', player.to_s, hais.to_s)
        else
          player.send('haipai', player.to_s, hais.to_s)
          @taku.except_send(player, 'haipai', player.to_s)
        end
        kaze = kaze.succ
      }
    end

    # ツモフェイズ
    def phase_tsumo
      hai = @yama.tsumo
      @player.tsumo(hai)
      cmd = [ 'tsumo', @player.to_s, @yama.rest.to_s ]
      if $config[:fullopen]
        @taku.send(cmd, hai.to_s)
      else
        @player.send(cmd, hai.to_s)
        @taku.except_send(@player, cmd)
      end
      if @yama.rest == 0
        @taku.each { |player| player.set_haitei }
      end
      @phase = :SUTEHAI
    end

    # 捨て牌選択フェイズ
    def phase_sutehai
      args = @player.send("sutehai?").recv
      case args.shift
      when 'sutehai'
        sutehai(args)
      when 'richi', 'openrichi'
        sutehai(args)
        if @player.can_richi?
          @taku.send('say', @player.to_s, 'richi')
          @player.richi
        end
      when 'tsumo'
        check_agari(@player, false)
      when 'ankan'
        hai = Mahjong::Hai[args[0]]
        if hai and mentsu = @player.ankan(hai)
          @taku.send('say', @player.to_s, 'kan')
          @taku.send('open', @player.to_s, mentsu.to_s)
          @phase = :TSUMO
        end
      #when 'kakan'
      else
        _sutehai(@player.choice_sutehai)
      end
    end

    # 鳴きフェイズ
    def phase_naki
      threads = Array.new
      reactions = Array.new
      turn = @turn
      (@taku.size - 1).times { |i|
        turn = (turn + 1) % @taku.size
        threads << Thread.start(turn, (i == 0)) { |_turn, can_chi|
          player = @taku[_turn]
          can_reactions = player.get_reaction(@sutehai, can_chi)
          unless can_reactions.empty?
            args = player.send('naku?', @sutehai.to_s, *can_reactions).recv
            if args and args[0] and can_reactions.include?(args[0].to_sym)
              reaction = Mahjong::REACTION.index(args.shift.to_sym)
              reactions << [ reaction, i, player, args ]
            end
          end
        }
      }
      ThreadsWait.all_waits(*threads)
      reactions.sort!
      while reaction = reactions.shift
        cmd = Mahjong::REACTION[reaction[0]]
        player = reaction[2]
        args = reaction[3]
        case cmd
        when :ron
          player.push(@sutehai)
          check_agari(player, @player)
        when :kan
          naki(player, @sutehai, @sutehai * 3)
        when :pon, :chi
          naki(player, @sutehai, args.collect { |hai| Mahjong::Hai[hai] })
        end
      end
      set_turn(@turn + 1)
      @phase = :TSUMO
    end

    # 捨て牌
    def sutehai(args)
      _sutehai(Mahjong::Hai[args[0]], args.include?('tsumogiri'))
    end

    def _sutehai(hai, is_tsumogiri = true)
      @sutehai, is_tsumogiri = @player.sutehai(hai, is_tsumogiri)
      cmd = [ 'sutehai', @player.to_s, @sutehai.to_s ]
      if is_tsumogiri
        cmd << 'tsumogiri'
      end
      @taku.send(*cmd)
      @phase = :NAKI
    end

    #
    def naki(player, hai, *args)
      if mentsu = player.naki(@sutehai, *args)
        @taku.send('say', player.to_s, (mentsu.kantsu? ? 'kan' :
                                        mentsu.kotsu? ? 'pon' :
                                        'chi'))
        @taku.send('open', player.to_s, mentsu.to_s, hai.to_s)
        set_turn(@taku.index(player))
        jump_phase(:SUTEHAI)
      else
        player.send('error')
      end
    end

    # 流局
    def ryukyoku
      @taku.send('ryukyoku')
      tenpai = Array.new
      noten = Array.new
      @taku.each { |player|
        if check_tenpai(player)
          tenpai << player
          @taku.except_send(player, 'open', player.to_s, player.hand)
          @taku.send('say', player.to_s, 'tenpai')
        else
          noten << player
          @taku.send('say', player.to_s, 'noten')
        end
      }
      if tenpai.size > 0 and noten.size > 0
        bappu = $config[:noten_bappu] / tenpai.size
        tenpai.each { |player|
          @taku.send('point', player.to_s, "+#{bappu}")
          player.point += bappu
        }
        bappu = $config[:noten_bappu] / noten.size
        noten.each { |player|
          @taku.send('point', player.to_s, "-#{bappu}")
          player.point -= bappu
        }
      end

      if $config[:rule_tenpai_renchan] and tenpai.include?(@taku[0])
        @game.renchan
      else
        @game.next(true)
      end
      jump_phase(:END)
    end

    # 聴牌チェック
    def check_tenpai(player)
      if player.richi?
        return true
      elsif player.tenpai?
        result = player.send('tenpai?').recv
        if result[0] == 'yes'
          return true
        end
      end
      false
    end

    #
    def check_agari(player, furikomi)
      agari = player.get_agari(furikomi)
      unless agari
        return
      end
      if agari.han == 0
        return
      end
      @taku.send('say', player.to_s, furikomi ? 'ron' : 'tsumo')
      @taku.send('open', player.to_s, player.hand)

      # 裏ドラ
      if player.richi?
        @dora.size.times { add_dora }
      end
      player.count_dora(@dora).times { agari << :DORA }

      @taku.send('agari', player.to_s, *agari.to_a)

      pay = agari.point
      point = 0
      if furikomi
        if player.oya?
          pay += pay / 2
        end
        pay = Mahjong.round_up(pay, 100)
        @taku.send('point', furikomi.to_s, "-#{pay}")
        furikomi.point -= pay
        point += pay
      else
        if player.oya?
          pay *= 2
        end
        @taku.each { |receiver|
          if receiver != player
            p = Mahjong.round_up(receiver.oya? ? pay * 2 : pay, 100)
            @taku.send('point', receiver.to_s, "-#{p}")
            receiver.point -= p
            point += p
          end
        }
      end
      # 一人打ち対応
      if point == 0
        point = Mahjong.round_up(pay, 100)
      end
      @taku.send('point', player.to_s, "+#{point}")
      player.point += point

      if player == @taku[0]
        @game.renchan
      else
        @game.next
      end
      jump_phase(:END)
    end

    #
    def set_turn(turn)
      @turn = (turn % @taku.size)
      @player = @taku[@turn]
    end

    #
    def jump_phase(phase)
      @phase = phase
      raise(ExitPhase)
    end
  end
end
