/***********************************************************************//**
	@file
	$Revision$
	$Author$
	$Date::                           $
***************************************************************************/
#ifndef  __LIBMAHJONG_HAND_H__
#define  __LIBMAHJONG_HAND_H__

#include <bitset>
#include "HaiArray.h"
#include "Mentsu.h"
#include "Agari.h"
#include "Kawa.h"

namespace mahjong {
/***********************************************************************//**
	手牌.
***************************************************************************/
class Hand {
  private:
    enum {
        FLAG_TENPAI, 
        FLAG_PURE, 
        FLAG_IPPATSU, 
        FLAG_RINSHAN, 
        FLAG_HAITEI, 
        FLAG_NOT_MENZEN, 
        FLAG_RICHI, 
        FLAG_OPEN, 
        FLAG_CLOSE, 
        FLAG_MAX
    };

  private:
    HaiArray menzen_;			/**< 手牌 */
    int fusehai_;			/**< 伏せ牌の数 */
    Mentsu::Vector openMentsu_;		/**< 晒したメンツ */
    Kawa kawa_;				/**< 捨て牌 */
    std::bitset<FLAG_MAX> flag_;
    const Hai* tsumoHai_;

  public:
    Hand();
    void reset();
    void setHaipai(const HaiArray& haipai);
    void open(const char* str, const Hai* sutehai = 0);

    const HaiArray& getMenzen() const;
    const Kawa& getKawa() const;
    int getFusehaiNum() const;
    int countHai(const Hai* hai) const;

    void setRichi();
    void setOpen();
    void setClose();

    bool isMenzen() const;
    bool isTurn() const;
    bool isRichi() const;
    bool isOpen() const;
    bool isClose() const;
    bool isAgari() const;
    bool isTenpai() const;
    HaiArray canRichi() const;

    void tsumo(const Hai* hai);
    Sutehai& sutehai(const Hai* hai, bool isTsumogiri);
    void naki(const Hai* hai, const HaiArray& openHais);

    bool getAgari(const Hai* hai = 0, bool isRon = false, 
                  Agari* result = 0) const;

    std::string toString() const;

    HaiArray getPon(const Hai* hai);
    HaiArray getChi(const Hai* hai);

    int getOpenMentsuNum() const;
    const Mentsu& getOpenMentsu(int index) const;

  private:
    void append(const Hai* hai);
    void drop(const Hai* hai);
    void drop(const HaiArray& hais);
    void appendMentsu(const Mentsu& mentsu);
    void divideMentsu(const HaiArray& haiArray, Agari::Vector& agari) const;
    void checkChitoi(Agari::Vector& agariVector) const;
    bool isKokushi() const;
};
/***********************************************************************//**
	$Id$
***************************************************************************/
}	/* namespace mahjong */
#endif	/* __LIBMAHJONG_HAND_H__ */
