/***********************************************************************//**
	@file
	$Revision: 73 $
	$Author: yatsuhashi $
	$Date:: 2009-03-20 03:07:24 +0900#$
***************************************************************************/
#ifndef __LIBMAHJONG_MENTSU_H__
#define __LIBMAHJONG_MENTSU_H__

#include <vector>
#include <bitset>
#include "libmahjong/HaiArray.h"

namespace mahjong {
/***********************************************************************//**
	面子.
***************************************************************************/
class Mentsu {
  public:
    typedef std::vector<Mentsu> Vector;

  private:
    enum {
        TYPE_TOITSU, 		/**< 対子 */
        TYPE_SHUNTSU, 		/**< 順子 */
        TYPE_KOTSU, 		/**< 刻子 */
        TYPE_KANTSU, 		/**< カンツ */
        TYPE_MAX
    };
    enum {
        FLAG_MENZEN, 		/**< 面前 */
        FLAG_DENY_ANKO, 	/**< 暗刻ではない */
        FLAG_MAX
    };

  private:
    int type_;			/**< 種別 */
    HaiArray haiArray_;
    int fu_;			/**< 基本符 */
    int machiFu_;		/**< 待ちの形に付く符 */
    std::bitset<FLAG_MAX> flag_;

  public:
    Mentsu(const HaiArray& hais, bool isMenzen = true);

    int getFu() const;
    int getSize() const;
    const Hai* getHai(int index = 0) const;
    int countHai(const Hai* hai) const;

    bool isMenzen() const;
    bool isToitsu() const;
    bool isShuntsu() const;
    bool isKotsu() const;
    bool isKantsu() const;
    bool isAnko() const;
    bool isPinfu() const;

    bool isInclude(const Hai* hai) const;
    bool isSameType(const Mentsu& other) const;

    void clearAgariHai();
    void setAgariHai(const Hai* hai, bool isRon);

    std::string toString() const;
};
/***********************************************************************//**
	$Id: Mentsu.h 73 2009-03-19 18:07:24Z yatsuhashi $
***************************************************************************/
}	/* namespace mahjong */
#endif	/* __LIBMAHJONG_MENTSU_H__ */
