/***********************************************************************//**
	@file
	$Revision: 76 $
	$Author: yatsuhashi $
	$Date:: 2009-03-25 02:02:55 +0900#$
***************************************************************************/
#ifndef __TEST_AGARITEST_H__
#define __TEST_AGARITEST_H__

#include <cppunit/extensions/HelperMacros.h>
#include "libmahjong.h"

namespace mahjong {
/***********************************************************************//**
	
***************************************************************************/
class AgariTest : public CPPUNIT_NS::TestCase {
    CPPUNIT_TEST_SUITE(AgariTest);
    CPPUNIT_TEST(testTanyao);
    CPPUNIT_TEST(testPinfu);
    CPPUNIT_TEST(testChanta);
    CPPUNIT_TEST(testChitoi);
    CPPUNIT_TEST(testToitoi);
    CPPUNIT_TEST(testHonroutou);
    CPPUNIT_TEST(testJunchan);
    CPPUNIT_TEST(testChinroutou);
    CPPUNIT_TEST(testSananko);
    CPPUNIT_TEST(testSankantsu);
    CPPUNIT_TEST(testSuanko);
    CPPUNIT_TEST(testSukantsu);
    CPPUNIT_TEST(testIpeikou);
    CPPUNIT_TEST(testRyanpeikou);
    CPPUNIT_TEST(testSanshoku);
    CPPUNIT_TEST(testSanshokudoukou);
    CPPUNIT_TEST(testItsu);
    CPPUNIT_TEST(testYakuhai);
    CPPUNIT_TEST(testShosangen);
    CPPUNIT_TEST(testDaisangen);
    CPPUNIT_TEST(testShosushi);
    CPPUNIT_TEST(testDaisushi);
    CPPUNIT_TEST(testHonitsu);
    CPPUNIT_TEST(testChinitsu);
    CPPUNIT_TEST(testTsuisou);
    CPPUNIT_TEST(testRyuisou);
    CPPUNIT_TEST(testChuren);
    CPPUNIT_TEST(testKokushi);
    CPPUNIT_TEST_SUITE_END();

  public:
    void testTanyao();
    void testPinfu();
    void testChanta();
    void testChitoi();
    void testToitoi();
    void testHonroutou();
    void testJunchan();
    void testChinroutou();
    void testSananko();
    void testSankantsu();
    void testSuanko();
    void testSukantsu();
    void testIpeikou();
    void testRyanpeikou();
    void testSanshoku();
    void testSanshokudoukou();
    void testItsu();
    void testYakuhai();
    void testShosangen();
    void testDaisangen();
    void testShosushi();
    void testDaisushi();
    void testHonitsu();
    void testChinitsu();
    void testTsuisou();
    void testRyuisou();
    void testChuren();
    void testKokushi();
  private:
    static Agari GetAgari(const char* str, const char* agariHai, 
                          bool isRon = true);
};
/***********************************************************************//**
	$Id: AgariTest.h 76 2009-03-24 17:02:55Z yatsuhashi $
***************************************************************************/
}	/* namespace mahjong */
#endif	/* __TEST_AGARITEST_H__ */
