/***********************************************************************//**
	@file
	$Revision: 82 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:46:44 +0900#$
***************************************************************************/
#include <wx/image.h>
#include "Color.h"

namespace openmj {
namespace gui {
/***********************************************************************//**
	コンストラクタ.
***************************************************************************/
Color::Color(unsigned char red, unsigned char green, unsigned char blue)
    : r(red), 
      g(green), 
      b(blue)
{}
/***********************************************************************//**
	
***************************************************************************/
void Color::apply(const Color& color) {
    r = (r * color.r) >> 7;
    g = (g * color.g) >> 7;
    b = (b * color.b) >> 7;
}
/***********************************************************************//**
	
***************************************************************************/
wxImage& Color::applyImage(wxImage& image) const {
    unsigned char* imageData = image.GetData();
    Color* pt = reinterpret_cast<Color*>(imageData);
    for(int y = 0; y < image.GetHeight(); y++) {
        for(int x = 0; x < image.GetWidth(); x++) {
            if(!image.IsTransparent(x, y)) {
                pt->apply(*this);
            }
            pt++;
        }
    }
    //image.SetData(imageData);
    return image;
}
/***********************************************************************//**
	$Id: Color.cpp 82 2009-03-28 13:46:44Z yatsuhashi $
***************************************************************************/
}	/* namespace gui */
}	/* namespace openmj */
