/***********************************************************************//**
	@file
	$Revision: 82 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:46:44 +0900#$
***************************************************************************/
#include "DrawPacket.h"

namespace openmj {
namespace gui {
/***********************************************************************//**
	コンストラクタ.
***************************************************************************/
DrawPacket::DrawPacket(const wxPoint& pos, int priority)
    : pos_(pos), 
      priority_(priority), 
      next_(0)
{}
/***********************************************************************//**
	座標を得る.
***************************************************************************/
const wxPoint& DrawPacket::getPos() const {
    return pos_;
}
/***********************************************************************//**
	
***************************************************************************/
DrawPacket* DrawPacket::getNext() const {
    return next_;
}
/***********************************************************************//**
	
***************************************************************************/
void DrawPacket::setNext(DrawPacket* next) {
    next_ = next;
}
/***********************************************************************//**
	比較.
***************************************************************************/
bool DrawPacket::operator<(const DrawPacket& other) const {
    return (priority_ != other.priority_)
        ? (priority_ < other.priority_)
        : (pos_.y < other.pos_.y);
}
/***********************************************************************//**
	$Id: DrawPacket.cpp 82 2009-03-28 13:46:44Z yatsuhashi $
***************************************************************************/
}	/* namespace gui */
}	/* namespace openmj */
