/***********************************************************************//**
	@file
	$Revision$
	$Author$
	$Date::                           $
***************************************************************************/
#ifndef __OPENMJ_GUI_TAKU_H__
#define __OPENMJ_GUI_TAKU_H__

#include <vector>
#include "wx/wx.h"
#include "libmahjong.h"
#include "Color.h"
#include "DrawQueue.h"

namespace openmj {
class Player;
namespace gui {
class Client;
class Choice;
/***********************************************************************//**
	
***************************************************************************/
class Taku : public wxPanel {
    typedef wxPanel super;

  private:
    static const int PLAYER_INFO_W	= 100;
    static const int PLAYER_INFO_H	= 50;
    static const wxPoint KAWA_TOP;
    static const wxPoint HAND_TOP;

  private:
    int width;
    wxPen pen;
    wxBrush brush;
    wxMemoryDC buff;
    wxMutex buffMutex;
    std::vector<const Player*> players;
    mahjong::HaiArray dora;
    DrawQueue drawQueue_;
    const Choice* choice_;

  public:
    Taku(wxWindow* parent, wxWindowID id, const wxPoint& pos, 
         const wxSize& size, long style, 
         const wxString& name = wxT("taku"));

    void setPlayers(const std::vector<const Player*>& players);
    void clearPlayers();

    void startKyoku();

    void appendDora(const mahjong::Hai* hai);

    void draw();
    void update();

    void beginChoice(const Choice* choice);
    void endChoice();
    int getChoiceIndex(int x, int y);

  private:
    const Client& getClient() const;

    void clear();
    void drawHai(const wxPoint& pos, const mahjong::Hai* hai, 
                 int rotate, int flag = 0);
    void drawHand(const mahjong::Hand* hand, int rotate);
    void drawOpenMentsu(wxPoint& pos, const mahjong::Mentsu& mentsu, 
                        int rotate);
    void drawKawa(const mahjong::Kawa& kawa, int rotate);
    void drawPlayerInfo(const Player* player, int seat);
    void drawDora();
    void drawInfo();

    bool isChoice(int index);
    bool canChoice(int index);
};
/***********************************************************************//**
	$Id$
***************************************************************************/
}	/* namespace gui */
}	/* namespace openmj */
#endif	/* __OPENMJ_GUI_TAKU_H__ */
