/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

/**
 * @ingroup bidiformat
 * @file bidiEntry.c
 * @brief Functions for Entry object.
 * @date $Date: 2004-10-22 17:32:53 +0900 (Fri, 22 Oct 2004) $
 * @version $Revision: 3 $
   copyright            : (C) 2004 by Turbolinux,Inc.
*/

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include <string.h>
#include "bidiEntry.h"

/** Marker color table*/
static const enumList enumMarker[] = {
  {1,"c"},
  {2,"m"},
  {3,"y"},
  {4,"k"},
  {5,"pm"},
  {6,"pc"},
  {-1,NULL}
};

/**
  * constructor that creates an empty Entry object.
  * @return Pointer to Entry object.
  */
Entry *newEntry(void)
{
  Entry *self;
  self = xmlMalloc(sizeof(Entry));
  if(!self) return NULL;
  memset(self, '\0', sizeof(Entry));
  
  self->EntryPrtLocalizationPtr=NULL;
  self->EntryPrtMarkerSuppliesPtr=NULL;
  self->EntryPrtAlertPtr=NULL;
  
  return self;
}

/**
  * destructor that delete an Entry object.
  * @param self Pointer to Entry object.
  */
void deleteEntry(Entry *self)
{
  if (self != NULL) {
    if(self->EntryPrtLocalizationPtr){
      deleteEntryPrtLoc(self->EntryPrtLocalizationPtr);
    }
    if(self->EntryPrtMarkerSuppliesPtr){
      deleteEntryPrtMarkSupp(self->EntryPrtMarkerSuppliesPtr);
    }
    if(self->EntryPrtAlertPtr){
      deleteEntryPrtAlt(self->EntryPrtAlertPtr);
    }
    xmlFree(self);
  }
}

/**
  * Get color character name from Marker color table(enumMarker[]).
  * @param eList Pointer to Marker color table
  * @param key   Number of enumPrtMarkSupIndex.
  * @return Pointer to color character string.
  */
static char *getEnumName(const enumList *eList,const int key)
{
  int i;
  if(!key||!eList){
    return NULL;
  }
  for(i=0;eList[i].name;i++){
    if(eList[i].value == key){
      return strdup(eList[i].name);
    }
  }
  return NULL;
}

/**
  * Get color character name from MarkerSuppliesIndex.
  * @param index Number of enumPrtMarkSupIndex.
  * @return Pointer to color character string.
  */
char *getIndexName(enumPrtMarkSupIndex index)
{
  return getEnumName(enumMarker,index);
}
