/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

/**
 * @file bidiParser.h
 * @brief Type definitions for Parser object.
 * @date $Date: 2004-10-22 17:32:53 +0900 (Fri, 22 Oct 2004) $
 * @version $Revision: 3 $
   copyright            : (C) 2004 by Turbolinux,Inc.
*/

#ifndef BIDI_PARSER_H
#define BIDI_PARSER_H

#include <libxml/xmlreader.h>
#include <bidiEntry.h>

#ifdef __cplusplus
extern "C" {
#endif
  
  /**
   * @enum State.
   * Enumerate types used in Parser object.
   */
  typedef enum {
    STATE_START = 0,            
    STATE_PRINTER_MIB,

    STATE_LOC_TABLE,
    STATE_LOC_ENTRY,
    STATE_LOC_LANG,
    STATE_LOC_CHARSET,
    
    STATE_MRKSUP_TABLE,
    STATE_MRKSUP_ENTRY,
    STATE_MRKSUP_INDEX,
    STATE_MRKSUP_TYPE,
    STATE_MRKSUP_DESCRIPTION,
    STATE_MRKSUP_SUPPLYUNIT,
    STATE_MRKSUP_MAXCAPACITY,
    STATE_MRKSUP_LEVEL,
    
    STATE_ALT_TABLE,
    STATE_ALT_ENTRY,
    STATE_ALT_SEVERITYLEVEL,
    STATE_ALT_GROUP,
    STATE_ALT_GROUPINDEX,
    STATE_ALT_CODE,
    STATE_ALT_DESCRIPTION
  } State;

  /**
   * @struct Parser.
   * Structure for parser which parse printer status written in XML format.
   */
  typedef struct {
    xmlTextReaderPtr reader; /**< libxml2 text reader. */
    State state;             /**< In which entry is parser.*/
  } Parser;
  
  Parser * newParser(void);
  void deleteParsery(Parser *);
  int parseParser(Parser *, const char *);
  Entry *fetchEntryFromParser(Parser *);
  int parseParserFromFile(Parser*, const char*);
  int parseParserFromFd(Parser*, int);
  int parseParserFromBuff(Parser*, const char*, int);

#ifdef __cplusplus
}
#endif

#endif
