/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

/**
 * @ingroup bidiformat
 * @file entryPrtLocalization.c
 * @brief functions of EntryPrtLocalization object.
 * @date $Date: 2004-10-22 17:32:53 +0900 (Fri, 22 Oct 2004) $
 * @version $Revision: 3 $
   copyright            : (C) 2004 by Turbolinux,Inc.
*/

#include <string.h>
#include <stdlib.h>

#include "bidiEntry.h"

/**
  * constructor that creates an empty EntryPrtLocalization object.
  *
  * @return Pointer to EntryPrtLocalization object
  */
EntryPrtLocalization *newEntryPrtLoc(void)
{
  EntryPrtLocalization *self;
  self = xmlMalloc(sizeof(EntryPrtLocalization));
  if(!self) return NULL;
  memset(self, '\0', sizeof(EntryPrtLocalization));
  return self;
}

/**
  * destructor that delete EntryPrtLocalization object.
  *
  * @param self Pointer to EntryPrtLocalization object
  */
void deleteEntryPrtLoc(EntryPrtLocalization *self)
{
  if(self->PrtLocLang) xmlFree(self->PrtLocLang);
}

/**
  * Function to set data to EntryPrtLocalization object.
  *
  * @param newentry Pointer to EntryPrtLocalization object
  * @param node_name Pointer to node name string
  * @param data      Pointer to data string
  */
void setEntryPrtLoc(EntryPrtLocalization *newentry,xmlChar *node_name, xmlChar *data)
{
  if (xmlStrcmp(node_name, "PrtLocalizationLanguage") == 0) {
    newentry->PrtLocLang = xmlStrdup(data);
  } else if (xmlStrcmp(node_name, "PrtLocalizationCharacterSet") == 0) {
    newentry->PrtLocCharSet = atoi(data);
  }
}
