/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

/**
 * @ingroup bidiformat
 * @file entryPrtMarkerSupplies.c
 * @brief functions of EntryPrtMarkerSupplies object.
 * @date $Date: 2004-10-22 17:32:53 +0900 (Fri, 22 Oct 2004) $
 * @version $Revision: 3 $
   copyright            : (C) 2004 by Turbolinux,Inc.
*/

#include <string.h>
#include <stdlib.h>

#include "bidiEntry.h"

/**
  * constructor that creates an empty EntryPrtMarkerSupplies object.
  *
  * @retval NULL Fail
  * @retval *EntryPrtMarkerSupplies Success
  */
EntryPrtMarkerSupplies *newEntryPrtMarkSupp(void)
{
  EntryPrtMarkerSupplies *self;
  self = xmlMalloc(sizeof(EntryPrtMarkerSupplies));
  if(!self) return NULL;
  memset(self,'\0',sizeof(EntryPrtMarkerSupplies));
  self->next = NULL;
  return self;
}

/**
  * destructor that delete EntryPrtMarkerSupplies object.
  *
  * @param self Pointer to EntryPrtMarkerSupplies object
  */
void deleteEntryPrtMarkSupp(EntryPrtMarkerSupplies *self)
{
  while(self){
    EntryPrtMarkerSupplies *next;
    if (self->PrtMarkSupDesc) xmlFree(self->PrtMarkSupDesc);
    next = self->next;
    xmlFree(self);
    self=next;
  }
} 

/**
  * Function to make new EntryPrtMarkerSupplies object.
  *
  * @param self Pointer to EntryPrtMarkerSupplies object
  * @retval NULL Fail
  * @retval *EntryPrtMarkerSupplies Success
  */
EntryPrtMarkerSupplies *addEntryPrtMarkSupp(EntryPrtMarkerSupplies *self)
{
  EntryPrtMarkerSupplies *newentry;
  newentry = newEntryPrtMarkSupp();
  if(!newentry) return NULL;
  
  if(self){
    EntryPrtMarkerSupplies *tmp=self;
    while(tmp->next) tmp = tmp->next;
    tmp->next = newentry;
  }else{
    self = newentry;
  }
  return self;
}

/**
  * Function to set data to EntryPrtMarkerSupplies object.
  *
  * @param entPrtMrkSup Pointer to EntryPrtMarkerSupplies object
  * @param node_name Pointer to node name string
  * @param data      Pointer to data string
  */
void setEntryPrtMarkSupp(EntryPrtMarkerSupplies *entPrtMrkSup,xmlChar *node_name, xmlChar *data)
{
  EntryPrtMarkerSupplies *entPrtMrkSupPtr=entPrtMrkSup;
  while(entPrtMrkSupPtr->next){
    entPrtMrkSupPtr = entPrtMrkSupPtr->next;
  }
  if(data){
    if (xmlStrcmp(node_name, "PrtMarkerSuppliesIndex") == 0) {
      entPrtMrkSupPtr->PrtMarkSupIndex = atol(data);
    } else if (xmlStrcmp(node_name, "PrtMarkerSuppliesType") == 0) {
      entPrtMrkSupPtr->PrtMarkSupType = atoi(data);
    } else if (xmlStrcmp(node_name, "PrtMarkerSuppliesDescription") == 0) {
      entPrtMrkSupPtr->PrtMarkSupDesc = xmlStrdup(data);
    } else if (xmlStrcmp(node_name, "PrtMarkerSuppliesSupplyUnit") == 0) {
      entPrtMrkSupPtr->PrtMarkSupSupUnit = atoi(data);
    } else if (xmlStrcmp(node_name, "PrtMarkerSuppliesMaxCapacity") == 0) {
      entPrtMrkSupPtr->PrtMarkSupMaxCap = atol(data);
    } else if (xmlStrcmp(node_name, "PrtMarkerSuppliesLevel") == 0) {
      entPrtMrkSupPtr->PrtMarkSupLevel = atol(data);
    }
  }
}
