/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

/**
 * @ingroup bidiformat
 * @file parserPrtAlert.c
 * @brief parse PrtAlertEntry.
 * @date $Date: 2004-10-22 17:32:53 +0900 (Fri, 22 Oct 2004) $
 * @version $Revision: 3 $
   copyright            : (C) 2004 by Turbolinux,Inc.
*/

#include <libxml/xmlreader.h>
#include "bidiParser.h"

// Prototyeps
void parseNodePrtAlert(Parser*,Entry*);

/**
  * parse XML data and set data to Entry object especially PrtAlertEntry.
  *
  * @param parser Pointer to Parser object.
  * @param entry Pointer to Entry object.
  * @return None.
  */
void parseNodePrtAlert(Parser *parser,Entry *entry)
{
  xmlElementType node_type;
  xmlNodePtr cur_node;
  xmlChar *element_name;
  xmlChar *data;
  
  node_type = xmlTextReaderNodeType(parser->reader);
  element_name = xmlTextReaderName(parser->reader);
  
  if (node_type == XML_READER_TYPE_ELEMENT) { /* in case start of tag */
    
    switch(parser->state){
    case STATE_START:
      //    case STATE_PRINTER_MIB:
      if (xmlStrcmp(element_name, "PrtAlertTable") == 0) {
	parser->state = STATE_ALT_TABLE;
      }
      break;
    case STATE_ALT_TABLE:
      if (xmlStrcmp(element_name, "PrtAlertEntry") == 0) {
	parser->state = STATE_ALT_ENTRY;
	entry->EntryPrtAlertPtr = addEntryPrtAlt(entry->EntryPrtAlertPtr);
      }
      break;
    case STATE_ALT_ENTRY:
      if (xmlStrcmp(element_name, "PrtAlertSeverityLevel") == 0) {
	parser->state = STATE_ALT_SEVERITYLEVEL;
      } else if (xmlStrcmp(element_name, "PrtAlertGroup") == 0) {
	parser->state = STATE_ALT_GROUP;
      } else if (xmlStrcmp(element_name, "PrtAlertGroupIndex") == 0) {
	parser->state = STATE_ALT_GROUPINDEX;
      } else if (xmlStrcmp(element_name, "PrtAlertCode") == 0) {
	parser->state = STATE_ALT_CODE;
      } else if (xmlStrcmp(element_name, "PrtAlertDescription") == 0) {
	parser->state = STATE_ALT_DESCRIPTION;
      }
      break;
    }
  } else if (node_type == XML_READER_TYPE_END_ELEMENT){ /* in case end of tag */
    switch(parser->state){
    case STATE_ALT_TABLE:
      parser->state = STATE_START;
      //      parser->state = STATE_PRINTER_MIB;
      break;
    case STATE_ALT_ENTRY:
      parser->state = STATE_ALT_TABLE;
      break;
    case STATE_ALT_SEVERITYLEVEL:
    case STATE_ALT_GROUP:
    case STATE_ALT_GROUPINDEX:
    case STATE_ALT_CODE:
    case STATE_ALT_DESCRIPTION:
      parser->state = STATE_ALT_ENTRY;
      break;
    }
  } else if (node_type == XML_READER_TYPE_TEXT){ /* in case text value */
    switch(parser->state){
    case STATE_ALT_SEVERITYLEVEL:
    case STATE_ALT_GROUP:
    case STATE_ALT_GROUPINDEX:
    case STATE_ALT_CODE:
    case STATE_ALT_DESCRIPTION:
      cur_node = xmlTextReaderCurrentNode(parser->reader);
      data = xmlTextReaderValue(parser->reader);
      setEntryPrtAlt(entry->EntryPrtAlertPtr,cur_node->parent->name,data);
      break;
    }
  }
}
