/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.screen;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.ChartScreenEvent;
import jp.sf.orangesignal.chart.ui.UpDownColorType;
import jp.sf.orangesignal.chart.ui.screen.SideScreen;
import jp.sf.orangesignal.chart.util.StringManager;

public class Option
extends SideScreen {
    private static final long serialVersionUID = 6190318641285237226L;
    private final JCheckBox split = new JCheckBox(StringManager.getString("split", new Object[0]));
    private final JCheckBox trace = new JCheckBox(StringManager.getString("trace", new Object[0]));
    private final JComboBox barColor = new JComboBox<UpDownColorType>(UpDownColorType.values());
    private final JComboBox lineColor = new JComboBox<UpDownColorType>(new UpDownColorType[]{UpDownColorType.GREEN_RED, UpDownColorType.RED_BLUE});
    public final JCheckBox advancedOptions = new JCheckBox(StringManager.getString("option.all", new Object[0]));

    public Option() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(layout);
        int y = 0;
        this.addCheckBox(layout, c, y++, this.split);
        this.addCheckBox(layout, c, y++, this.trace);
        this.addSeparator(layout, c, y++);
        this.addLabel(layout, c, y++, new JLabel(StringManager.getString("label.color", new Object[0])));
        this.addComboBox(layout, c, y++, new JLabel(StringManager.getString("color.bar", new Object[0])), this.barColor);
        this.addComboBox(layout, c, y++, new JLabel(StringManager.getString("color.line", new Object[0])), this.lineColor);
        this.addSeparator(layout, c, y++);
        this.addCheckBox(layout, c, y++, this.advancedOptions);
        this.addLastSpace(layout, c, y);
    }

    @Override
    public void save(ChartSettings s) {
        s.split = this.split.isSelected();
        s.trace = this.trace.isSelected();
        s.updownBarColors = (UpDownColorType)((Object)this.barColor.getSelectedItem());
        s.updownLineColors = (UpDownColorType)((Object)this.lineColor.getSelectedItem());
        s.advancedOptions = this.advancedOptions.isSelected();
    }

    @Override
    public void load(ChartSettings s) {
        this.split.setSelected(s.split);
        this.trace.setSelected(s.trace);
        this.barColor.setSelectedItem((Object)s.updownBarColors);
        this.lineColor.setSelectedItem((Object)s.updownLineColors);
        this.advancedOptions.setSelected(s.advancedOptions);
    }

    @Override
    public void datasetSwitch(ChartEvent e) {
        this.notify = false;
        boolean enabled = e.getDataset() != null;
        this.split.setEnabled(enabled);
        this.trace.setEnabled(enabled);
        this.barColor.setEnabled(enabled);
        this.lineColor.setEnabled(enabled);
        this.advancedOptions.setEnabled(enabled);
        if (enabled) {
            this.load(e.getSettings());
        }
        this.notify = true;
    }

    @Override
    public void periodSwitch(ChartEvent e) {
    }

    @Override
    public void settingChanged(ChartEvent e) {
    }

    @Override
    public void positionChanged(ChartScreenEvent e) {
    }
}

