package jp.sourceforge.orangesignal.ta.dataset.loader;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertThat;

import java.util.HashMap;
import java.util.Map;

import jp.sourceforge.orangesignal.ta.dataset.TimeSeriesDataset;
import jp.sourceforge.orangesignal.ta.dataset.TimeSeriesDataset.Interval;

import org.junit.Test;


public class FileDatasetLoaderTest {

	private static final String PATH = "src/test/resources/data/n225.csv";
	private static final String SYMBOL = "n225";

	@Test
	public void ゲッター・セッター() {
		final FileDatasetLoader loader = new FileDatasetLoader();

		final PriceDataLoader pdl = new PriceDataLoader();
		loader.setLoader(pdl);
		assertThat(loader.getLoader(), is(pdl));

		loader.setInterval(Interval.MONTHLY);
		assertThat(loader.getInterval(), is(Interval.MONTHLY));

		final Map<String, String> symbolMap = new HashMap<String, String>();
		symbolMap.put(SYMBOL, PATH);
		loader.setSymbolMap(symbolMap);
		assertThat(loader.getSymbolMap(), is(symbolMap));
	}

	@Test(expected = LoadException.class)
	public void ロード失敗・シンボルマップなし() {
		final FileDatasetLoader loader = new FileDatasetLoader();
		loader.setSymbol(SYMBOL);
		loader.load();
	}

	@Test
	public void ロード成功() {
		final Map<String, String> symbolMap = new HashMap<String, String>();
		symbolMap.put(SYMBOL, PATH);
		final FileDatasetLoader loader = new FileDatasetLoader();
		loader.setSymbolMap(symbolMap);

		loader.setSymbol(SYMBOL);
		final TimeSeriesDataset dataset = loader.load();
		assertNotNull(dataset);
		assertThat(dataset.getSymbol(), is(SYMBOL));
	}

}
