/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.order;

/**
 * 注文方法の種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum OrderTiming {

	/**
	 * 当日の終値で成行注文する事を表します。
	 */
	CURRENT_CLOSE { @Override public OrderType getOrderType() { return OrderType.MARKET; } },

	/**
	 * 翌日の始値で成行注文する事を表します。
	 */
	NEXT_OPEN { @Override public OrderType getOrderType() { return OrderType.MARKET; } },

	/**
	 * 翌日の終値で成行注文する事を表します。
	 */
	NEXT_CLOSE { @Override public OrderType getOrderType() { return OrderType.MARKET; } },

	/**
	 * 翌日に指値注文する事を表します。
	 */
	NEXT_LIMIT { @Override public OrderType getOrderType() { return OrderType.LIMIT; } },

	/**
	 * 翌日に逆指値注文する事を表します。
	 */
	NEXT_STOP { @Override public OrderType getOrderType() { return OrderType.STOP; } };

	/**
	 * この列挙型に対応する注文の種類を返します。
	 * 
	 * @return 注文の種類
	 */
	public abstract OrderType getOrderType();

}
