package jp.sourceforge.orangesignal.trading.backtest.launcher;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.IOException;

import javax.annotation.Resource;

import jp.sourceforge.orangesignal.trading.backtest.BacktesterEvent;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/backtester.xml" })
public class BacktesterLauncherTest {

	@Resource
	private BacktesterLauncher launcher;

	@Test
	public void testCreateOptions() {
		final Options options = BacktesterLauncher.createOptions();
		assertNotNull(options);
		assertNotNull(options.getOption(BacktesterLauncher.OPT_HELP));
		assertNotNull(options.getOption(BacktesterLauncher.OPT_VERSION));
		assertNotNull(options.getOption(BacktesterLauncher.OPT_FILE));
		assertNotNull(options.getOption(BacktesterLauncher.OPT_TIME));
		assertNotNull(options.getOption(BacktesterLauncher.OPT_INFO));
	}

	@Test
	public void testCreateGeneralOptionGroup() {
		final OptionGroup group = BacktesterLauncher.createGeneralOptionGroup();
		assertNotNull(group);
		assertNotNull(group.getOptions());
	}

	@Test
	public void testMain() {
		BacktesterLauncher.main(new String[]{});
		assertTrue(true);
	}

	@Test
	public void testLaunch() throws ParseException, IOException {
		final CommandLine commandline = new PosixParser().parse(BacktesterLauncher.options, new String[]{});
		launcher.launch(commandline);
		assertTrue(true);
	}

	@Test
	public void testBacktestStart() {
		final BacktesterEvent event = new BacktesterEvent(this, 3, 1, "n225", "日経平均株価 255種", null);
		launcher.backtestStart(event);
		assertTrue(true);
	}

	@Test
	public void testBacktestProcessed() {
		final BacktesterEvent event = new BacktesterEvent(this, 3, 1, "n225", "日経平均株価 255種", null);
		launcher.backtestProcessed(event);
		assertTrue(true);
	}

}
