package jp.sourceforge.orangesignal.trading.commission;

import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.SerializationUtils;
import org.junit.Before;
import org.junit.Test;

public class CommissionSystemTest {

	private List<CommissionUnit> list;

	@Before
	public void setUp() throws Exception {
		final List<CommissionUnit> list = new ArrayList<CommissionUnit>();
		list.add(new FixedCommission( 100000,    0));
		list.add(new FixedCommission( 300000,  315));
		list.add(new FixedCommission( 500000,  525));
		list.add(new FixedCommission(1000000, 1050));
		list.add(new FixedCommission(2000000, 2100, 1000000, 1050, 105000));
		this.list = list;
	}

	@Test
	public void testCommissionSystem() {
		new CommissionSystem();
		assertTrue(true);
	}

	@Test
	public void testCommissionSystemCommissionUnit() {
		new CommissionSystem(new FixedCommission());
		assertTrue(true);
	}

	@Test
	public void testCommissionSystemListOfCommissionUnit() {
		new CommissionSystem(this.list);
		assertTrue(true);
	}

	@Test
	public void testGetCommissionList() {
		assertTrue(new CommissionSystem(this.list).getCommissionList().size() == this.list.size());
	}

	@Test
	public void testSetCommissionList() {
		final CommissionSystem cs = new CommissionSystem();
		cs.setCommissionList(this.list);
		assertTrue(cs.getCommissionList().size() == this.list.size());
	}

	@Test
	public void testAddCommission() {
		final CommissionSystem cs = new CommissionSystem(this.list);
		cs.addCommission(new FixedCommission(200000, 105));
		assertTrue(cs.getCommissionList().size() == (this.list.size() + 1));
	}

	@Test
	public void testCalcCommission() {
		final CommissionSystem cs = new CommissionSystem(this.list);
		assertTrue(cs.calcCommission(10000,   1) ==    0D);
		assertTrue(cs.calcCommission(10000,  10) ==    0D);
		assertTrue(cs.calcCommission(10000,  20) ==  315D);
		assertTrue(cs.calcCommission(10000,  30) ==  315D);
		assertTrue(cs.calcCommission(10000,  40) ==  525D);
		assertTrue(cs.calcCommission(10000,  50) ==  525D);
		assertTrue(cs.calcCommission(10000, 100) == 1050D);
		assertTrue(cs.calcCommission(10000, 200) == 2100D);
		assertTrue(cs.calcCommission(10000, 300) == 3150D);
		assertTrue(cs.calcCommission(10000, 400) == 4200D);
		assertTrue(cs.calcCommission(10000, 10000) == 105000D);
	}

	@Test
	public void testSerialization() {
		final byte[] bytes = SerializationUtils.serialize(new CommissionSystem());
		assertTrue(true);
		final Object obj = SerializationUtils.deserialize(bytes);
		assertTrue(obj instanceof CommissionSystem);
	}

}
