/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.candle.generator;

/**
 * ローソク足情報生成時に使用されるローソク足生成設定情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public final class CandlestickGeneratorSetting {

	/**
	 * ローソク足基準値の元となるローソク足範囲の種類を表す列挙型を提供します。
	 */
	public enum Range {

		/**
		 * ローソク
		 */
		CANDLE,

		/**
		 * 実体
		 */
		BODY,

		/**
		 * 影(ヒゲ)
		 */
		SHADOW;

	}

	/**
	 * ローソク足範囲の種類を保持します。
	 */
	public final Range range;

	/**
	 * 係数を保持します。
	 */
	public final double factor;

	/**
	 * コンストラクタです。
	 * 
	 * @param range ローソク足範囲の種類
	 * @param factor 係数
	 * @throws NullPointerException ローソク足範囲の種類に <code>null</code> が指定された場合
	 * @throws IllegalArgumentException 係数に <code>0</code> 未満の値が指定された場合
	 */
	public CandlestickGeneratorSetting(final Range range, final double factor) throws NullPointerException, IllegalArgumentException {
		if (range == null)
			throw new NullPointerException();
		if (factor < 0.0)
			throw new IllegalArgumentException();
		this.range = range;
		this.factor = factor;
	}

}
