/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.candle.generator;

/**
 * ローソク足情報にトレンド情報を結びつけるトレンド処理のインターフェースです。
 * 
 * @author 杉澤 浩二
 */
public interface TrendProcessor {

	/**
	 * 指定されたローソク足情報へトレンド情報を付与します。
	 * 
	 * @param c ローソク足
	 * @return トレンド情報が付与されたローソク足
	 * @throws TrendProcessorException トレンド情報の付与に必要な情報がなく付与に失敗した場合
	 */
	public void execute(DefaultCandlestick[] c) throws TrendProcessorException;

}
