package jp.sourceforge.orangesignal.ta.dataset.loader;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import java.io.IOException;
import java.util.List;

import jp.sourceforge.orangesignal.ta.dataset.PriceData;

import org.junit.Test;

public class PriceDataLoaderTest {

	@Test
	public void testPriceDataLoader() {
		new PriceDataLoader();
		assertTrue(true);
	}

	@Test
	public void testPriceDataLoaderMapOfPriceDataColumnTypeInteger() {
		assertNotNull(PriceDataLoader.DEFAULT_COLUMN_MAP);
	}

	@Test
	public void testGetSeparator() {
		final PriceDataLoader loader = new PriceDataLoader();
		assertThat(loader.getSeparator(), is(PriceDataLoader.DEFAULT_SEPARATOR));
	}

	@Test
	public void testSetSeparator() {
		final PriceDataLoader loader = new PriceDataLoader();
		loader.setSeparator("\t");
		assertThat(loader.getSeparator(), is("\t"));
	}

	@Test
	public void testGetEncoding() {
		final PriceDataLoader loader = new PriceDataLoader();
		assertThat(loader.getEncoding(), is(PriceDataLoader.DEFAULT_ENCODING));
	}

	@Test
	public void testSetEncoding() {
		final PriceDataLoader loader = new PriceDataLoader();
		loader.setEncoding("utf-8");
		assertThat(loader.getEncoding(), is("utf-8"));
	}

	@Test
	public void testGetColumnMap() {
		final PriceDataLoader loader = new PriceDataLoader();
		assertThat(loader.getColumnMap(), is(PriceDataLoader.DEFAULT_COLUMN_MAP));
	}

	@Test
	public void testSetColumnMap() {
		final PriceDataLoader loader = new PriceDataLoader();
		loader.setColumnMap(PriceDataLoader.DEFAULT_COLUMN_MAP);
		assertThat(loader.getColumnMap(), is(PriceDataLoader.DEFAULT_COLUMN_MAP));
	}

	@Test
	public void testGetTitleRow() {
		final PriceDataLoader loader = new PriceDataLoader();
		assertThat(loader.getTitleRow(), is(0));
	}

	@Test
	public void testSetTitleRow() {
		final PriceDataLoader loader = new PriceDataLoader();
		loader.setTitleRow(3);
		assertThat(loader.getTitleRow(), is(3));
	}

	@Test
	public void testGetTitleMap() {
		final PriceDataLoader loader = new PriceDataLoader();
		assertThat(loader.getTitleMap(), is(PriceDataLoader.DEFAULT_TITLE_MAP));
	}

	@Test
	public void testSetTitleMap() {
		final PriceDataLoader loader = new PriceDataLoader();
		loader.setTitleMap(PriceDataLoader.DEFAULT_TITLE_MAP);
		assertThat(loader.getTitleMap(), is(PriceDataLoader.DEFAULT_TITLE_MAP));
	}

	@Test
	public void testGetStartRow() {
		final PriceDataLoader loader = new PriceDataLoader();
		assertThat(loader.getStartRow(), is(1));
	}

	@Test
	public void testSetStartRow() {
		final PriceDataLoader loader = new PriceDataLoader();
		loader.setStartRow(5);
		assertThat(loader.getStartRow(), is(5));
	}

	@Test
	public void testGetDatePatterns() {
		final PriceDataLoader loader = new PriceDataLoader();
		assertThat(loader.getDatePatterns(), is(PriceDataLoader.DEFAULT_DATE_PATTERNS));
	}

	@Test
	public void testSetDatePatterns() {
		final PriceDataLoader loader = new PriceDataLoader();
		loader.setDatePatterns(PriceDataLoader.DEFAULT_DATE_PATTERNS);
		assertThat(loader.getDatePatterns(), is(PriceDataLoader.DEFAULT_DATE_PATTERNS));
	}

	@Test
	public void testGetNumberPatterns() {
		final PriceDataLoader loader = new PriceDataLoader();
		assertNull(loader.getNumberPatterns());
	}

	@Test
	public void testSetNumberPatterns() {
		final PriceDataLoader loader = new PriceDataLoader();
		final String[] numberPatterns = new String[]{ "0,000" };
		loader.setNumberPatterns(numberPatterns);
		assertThat(loader.getNumberPatterns(), is(numberPatterns));
	}

	@Test
	public void testIsIgnore() {
		final PriceDataLoader loader = new PriceDataLoader();
		assertTrue(loader.isIgnore());
	}

	@Test
	public void testSetIgnore() {
		final PriceDataLoader loader = new PriceDataLoader();
		loader.setIgnore(false);
		assertFalse(loader.isIgnore());
	}

	private static final String PATH = "src/test/resources/data/";

	@Test
	public void testLoad() throws IOException {
		final PriceDataLoader loader = new PriceDataLoader();
		final List<PriceData> results1 = loader.load(PATH + "n225.csv");
		assertNotNull(results1);
		assertFalse(results1.isEmpty());

		final List<PriceData> results2 = loader.load(PATH + "n225.zip");
		assertNotNull(results2);
		assertFalse(results2.isEmpty());

		final List<PriceData> results3 = loader.load(PATH + "n225.lzh");
		assertNotNull(results3);
		assertFalse(results3.isEmpty());
	}

	@Test(expected = IOException.class)
	public void testLoadIOException() throws IOException {
		final PriceDataLoader loader = new PriceDataLoader();
		loader.load("");
	}

	@Test(expected = IllegalStateException.class)
	public void testLoadIllegalStateException() throws IOException {
		final PriceDataLoader loader = new PriceDataLoader();
		loader.setColumnMap(null);
		loader.setTitleRow(-1);
		loader.load(PATH + "n225.csv");
	}

}
