/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.trading.order.OrderTiming.NEXT_STOP;
import static jp.sourceforge.orangesignal.trading.strategy.StrategyStatus.NEXT;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;

public class MomentumLongEntry extends Momentum {

	protected Number[] high;

	@Override
	public void init() {
		super.init();
		this.high = getDataset().getHigh();
	}

	@Override
	public StrategyStatus process() {
		final int i = getCurrentDataIndex();
		if (high[i] != null && mom1[i] != null && mom2[i] != null && mom1[i].doubleValue() > 0 && mom2[i].doubleValue() > 0)
			buy(getStrategyName(), NEXT_STOP, high[i].doubleValue() + 1);
		return NEXT;
	}

	@Override
	public void terminate() {
		this.high = null;
		super.terminate();
	}

}
