/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.trading.order.OrderTiming.NEXT_STOP;
import static jp.sourceforge.orangesignal.trading.strategy.StrategyStatus.NEXT;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;

public class MomentumShortEntry extends Momentum {

	protected Number[] low;

	@Override
	public void init() {
		super.init();
		this.low = getDataset().getLow();
	}

	@Override
	public StrategyStatus process() {
		final int i = getCurrentDataIndex();
		if (low[i] != null && mom1[i] != null && mom2[i] != null && mom1[i].doubleValue() < 0 && mom2[i].doubleValue() < 0)
			sellShort(getStrategyName(), NEXT_STOP, low[i].doubleValue() - 1);
		return NEXT;
	}

	@Override
	public void terminate() {
		this.low = null;
		super.terminate();
	}

}
