/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.dataset;

import java.util.Date;

/**
 * 株式分割データのインタフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface SplitData {

	/**
	 * <p>日時を返します。</p>
	 * 
	 * @return 日時
	 */
	public Date getDate();

	/**
	 * <p>株式分割数を返します。</p>
	 * 
	 * @return 株式分割数
	 */
	public Number getSplit();

}
