/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.event;

import java.awt.Point;
import java.util.EventObject;

/**
 * チャート画面のイベントです。
 * 
 * @author 杉澤 浩二
 * @see ChartScreenListener
 */
public class ChartScreenEvent extends EventObject {

	private static final long serialVersionUID = 5767475920883245522L;

	/**
	 * マウス座標を保持します。
	 */
	private transient Point mousePosition;

	/**
	 * 開始位置を保持します。
	 */
	private int start;

	/**
	 * 期間を保持します。
	 */
	private int period;

	/**
	 * 座標を保持します。
	 */
	private int position;

	/**
	 * 付属的な情報を保持します。
	 * 実装は価格帯別出来高情報を保持します。
	 */
	private Object info;

	/**
	 * コンストラクタです。
	 * 
	 * @param source イベントの発生元のオブジェクト
	 * @param mousePosition マウス座標
	 * @param start 開始位置
	 * @param period 期間
	 * @param position 座標
	 * @throws IllegalArgumentException <code>source</code> が <code>null</code> の場合
	 */
	public ChartScreenEvent(
		final Object source,
		final Point mousePosition,
		final int start,
		final int period,
		final int position)
	{
		this(source, mousePosition, start, period, position, null);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param source イベントの発生元のオブジェクト
	 * @param mousePosition マウス座標
	 * @param start 開始位置
	 * @param period 期間
	 * @param position 座標
	 * @param info 付属的な情報
	 * @throws IllegalArgumentException <code>source</code> が <code>null</code> の場合
	 */
	public ChartScreenEvent(
		final Object source,
		final Point mousePosition,
		final int start,
		final int period,
		final int position,
		final Object info)
	{
		super(source);
		this.mousePosition = mousePosition;
		this.start = start;
		this.period = period;
		this.position = position;
		this.info = info;
	}

	/**
	 * マウス座標を返します。
	 * 
	 * @return マウス座標
	 */
	public Point getMousePosition() { return mousePosition; }

	/**
	 * 開始位置を返します。
	 * 
	 * @return 開始位置
	 */
	public int getStart() { return start; }

	/**
	 * 期間を返します。
	 * 
	 * @return 期間
	 */
	public int getPeriod() { return period; }

	/**
	 * 座標を保持します。
	 * 
	 * @return 座標
	 */
	public int getPosition() { return position; }

	/**
	 * 付属的な情報を返します。付属情報がない場合は <code>null</code> を返します。
	 * 実装は価格帯別出来高情報を返します。
	 * 
	 * @return 付属的な情報または <code>null</code>
	 */
	public Object getInfo() { return info; }

}
