/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.util;

/**
 * クラス操作に関するユーティリティを提供します。
 * 
 * @author 杉澤 浩二
 * @since 2.1
 */
public abstract class ClassUtils {

	/**
	 * <p>パッケージ区切り記号: <code>'&#x2e;' == {@value}</code>.</p>
	 */
	public static final char PACKAGE_SEPARATOR_CHAR = '.';

	/**
	 * <p>パッケージ区切り文字: <code>"&#x2e;"</code>.</p>
	 */
	public static final String PACKAGE_SEPARATOR = String.valueOf(PACKAGE_SEPARATOR_CHAR);

	/**
	 * <p>内部クラス区切り記号: <code>'$' == {@value}</code>.</p>
	 */
	public static final char INNER_CLASS_SEPARATOR_CHAR = '$';

	/**
	 * <p>内部クラス区切り文字: <code>"$"</code>.</p>
	 */
	public static final String INNER_CLASS_SEPARATOR = String.valueOf(INNER_CLASS_SEPARATOR_CHAR);

	//-----------------------------------------------------------------------
	// Package name

	/**
	 * 指定されたクラスからパッケージ名を返します。
	 * クラスに <code>null</code> が指定された場合は、空の文字列を返します。
	 * 
	 * @param cls パッケージ名を取得するクラス
	 * @return パッケージ名。または空の文字列
	 */
	public static String getPackageName(final Class<?> cls) {
		if (cls == null) {
			return StringUtils.EMPTY;
		}
		return getPackageName(cls.getName());
	}

	/**
	 * 指定されたクラス名からパッケージ名を返します。
	 * クラス名に <code>null</code> が指定された場合は、空の文字列を返します。
	 * 
	 * @param className パッケージ名を取得するクラス名
	 * @return パッケージ名。または空の文字列
	 */
	public static String getPackageName(final String className) {
		if (className == null) {
			return StringUtils.EMPTY;
		}
		final int i = className.lastIndexOf(PACKAGE_SEPARATOR_CHAR);
		if (i == -1) {
			return StringUtils.EMPTY;
		}
		return className.substring(0, i);
	}

	public static Class<?> getClass(final String className, final Class<?> callingClass) throws ClassNotFoundException {
		try {
			return Thread.currentThread().getContextClassLoader().loadClass(className);
		} catch (ClassNotFoundException e) {
			return ClassUtils.class.getClassLoader().loadClass(className);
		}
	}

}
