package jp.sf.orangesignal.ta.candle;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import jp.sf.orangesignal.ta.TechnicalAnalysis;
import jp.sf.orangesignal.ta.candle.generator.CandlestickGenerator;
import jp.sf.orangesignal.ta.candle.generator.KagiTrendProcessor;
import jp.sf.orangesignal.ta.data.CsvPriceLoader;
import jp.sf.orangesignal.ta.data.model.Price;
import jp.sf.orangesignal.ta.data.model.PriceDataset;

import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CandlestickPatternsTest {

	private static Candlestick[] c;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		final CsvPriceLoader loader = (CsvPriceLoader) new ClassPathXmlApplicationContext("applicationContext.xml").getBean("loader", CsvPriceLoader.class);
		final PriceDataset dataset = PriceDataset.newInstance(loader.load("n225").toArray(new Price[0]));
		c = new CandlestickGenerator().generate(
				dataset.getDate(),
				dataset.getOpen(),
				dataset.getHigh(),
				dataset.getLow(),
				dataset.getClose(),
				new KagiTrendProcessor(TechnicalAnalysis.kagi(dataset.getDate(), dataset.getClose(), 3.0D))
			);
	}

	@Test
	public void testCandlestickPatterns() {
		new CandlestickPatterns();
	}

	/* ---------------------------------------------------------------------- */
	/* 一本足【指標】反転・継続【信頼性】低 */

	@Test()
	public void testBullishLongWhiteDay() {
		final boolean[] b = CandlestickPatterns.bullishLongWhiteDay(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishLongBlackDay() {
		final boolean[] b = CandlestickPatterns.bearishLongBlackDay(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishShortWhiteDay() {
		final boolean[] b = CandlestickPatterns.bullishShortWhiteDay(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishShortBlackDay() {
		final boolean[] b = CandlestickPatterns.bearishShortBlackDay(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 一本足【指標】反転【信頼性】低 */

	@Test()
	public void testBullishBeltHoldCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishBeltHold(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishBeltHoldCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishBeltHold(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishBeltHoldCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishBeltHold(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishBeltHoldCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishBeltHold(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishHammerCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishHammer(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishHammerCandlestickArrayBooleanBoolean() {
		final boolean[] b = CandlestickPatterns.bullishHammer(c, false, true);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishHangingManCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishHangingMan(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishHangingManCandlestickArrayBooleanBoolean() {
		final boolean[] b = CandlestickPatterns.bearishHangingMan(c, false, true);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 一本足【指標】反転【信頼性】中 */

	@Test()
	public void testBullishDragonflyDojiCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishDragonflyDoji(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishDragonflyDojiCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishDragonflyDoji(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDragonflyDojiCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishDragonflyDoji(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDragonflyDojiCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishDragonflyDoji(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishLongLeggedDojiCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishLongLeggedDoji(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishLongLeggedDojiCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishLongLeggedDoji(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishLongLeggedDojiCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishLongLeggedDoji(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishLongLeggedDojiCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishLongLeggedDoji(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 二本足【指標】反転【信頼性】低 */

	@Test()
	public void testBullishInvertedHammerCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishInvertedHammer(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishInvertedHammerCandlestickArrayBooleanBoolean() {
		final boolean[] b = CandlestickPatterns.bullishInvertedHammer(c, false, true);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishShootingStarCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishShootingStar(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishShootingStarCandlestickArrayBooleanBoolean() {
		final boolean[] b = CandlestickPatterns.bearishShootingStar(c, false, true);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishHaramiCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishHarami(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishHaramiCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishHarami(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishHaramiCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishHarami(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishHaramiCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishHarami(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 二本足【指標】反転【信頼性】中 */

	@Test()
	public void testBullishHaramiCrossCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishHaramiCross(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishHaramiCrossCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishHaramiCross(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishHaramiCrossCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishHaramiCross(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishHaramiCrossCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishHaramiCross(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishEngulfingCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishEngulfing(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishEngulfingCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishEngulfing(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishEngulfingCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishEngulfing(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishEngulfingCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishEngulfing(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishGravestoneDojiCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishGravestoneDoji(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishGravestoneDojiCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishGravestoneDoji(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishGravestoneDojiCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishGravestoneDoji(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishGravestoneDojiCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishGravestoneDoji(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishCounterAttackCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishCounterAttack(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishCounterAttackCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishCounterAttack(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishCounterAttackCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishCounterAttack(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishCounterAttackCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishCounterAttack(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishMeetingLinesCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishMeetingLines(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishMeetingLinesCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishMeetingLines(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishMeetingLinesCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishMeetingLines(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishMeetingLinesCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishMeetingLines(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishDojiStarCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishDojiStar(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishDojiStarCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishDojiStar(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDojiStarCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishDojiStar(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDojiStarCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishDojiStar(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishHomingPigeonCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishHomingPigeon(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishHomingPigeonCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishHomingPigeon(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDescendingHawkCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishDescendingHawk(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDescendingHawkCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishDescendingHawk(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishMatchingLowCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishMatchingLow(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishMatchingLowCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishMatchingLow(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishMatchingHighCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishMatchingHigh(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishMatchingHighCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishMatchingHigh(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishTweezerBottomCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishTweezerBottom(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishTweezerBottomCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishTweezerBottom(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishTweezerTopCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishTweezerTop(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishTweezerTopCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishTweezerTop(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 二本足【指標】反転【信頼性】高 */

	@Test()
	public void testBullishKicking() {
		final boolean[] b = CandlestickPatterns.bullishKicking(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishKicking() {
		final boolean[] b = CandlestickPatterns.bearishKicking(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishPiercingLineCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishPiercingLine(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishPiercingLineCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishPiercingLine(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDarkCloudCoverCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishDarkCloudCover(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDarkCloudCoverCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishDarkCloudCover(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 二本足【指標】継続【信頼性】低 */

	@Test()
	public void testBullishSeparatingLinesCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishSeparatingLines(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishSeparatingLinesCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishSeparatingLines(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishSeparatingLinesCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishSeparatingLines(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishSeparatingLinesCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishSeparatingLines(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishThrustingCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishThrusting(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishThrustingCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishThrusting(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 二本足【指標】継続【信頼性】中 */

	@Test()
	public void testBearishOnNeckCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishOnNeck(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishOnNeckCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishOnNeck(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishInNeckCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishInNeck(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishInNeckCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishInNeck(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 三本足【指標】反転【信頼性】中 */

	@Test()
	public void testBullishTriStarCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishTriStar(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishTriStarCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishTriStar(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishTriStarCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishTriStar(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishTriStarCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishTriStar(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishTwoCrowsCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishTwoCrows(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishTwoCrowsCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishTwoCrows(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishThreeStarsInTheSouthCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishThreeStarsInTheSouth(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishThreeStarsInTheSouthCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishThreeStarsInTheSouth(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishUniqueThreeRiverBottomCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishUniqueThreeRiverBottom(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishUniqueThreeRiverBottomCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishUniqueThreeRiverBottom(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishStickSandwichCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishStickSandwich(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishStickSandwichCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishStickSandwich(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishAdvanceBlockCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishAdvanceBlock(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishAdvanceBlockCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishAdvanceBlock(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishStalledPatternCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishStalledPattern(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishStalledPatternCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishStalledPattern(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDeliberationCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishDeliberation(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDeliberationCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishDeliberation(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 三本足【指標】反転【信頼性】高 */

	@Test()
	public void testBullishAbandonedBabyCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishAbandonedBaby(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishAbandonedBabyCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishAbandonedBaby(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishAbandonedBabyCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishAbandonedBaby(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishAbandonedBabyCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishAbandonedBaby(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishMorningDojiStarCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishMorningDojiStar(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishMorningDojiStarCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishMorningDojiStar(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishEveningDojiStarCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishEveningDojiStar(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishEveningDojiStarCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishEveningDojiStar(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishMorningStarCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishMorningStar(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishMorningStarCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishMorningStar(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishEveningStarCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishEveningStar(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishEveningStarCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishEveningStar(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishThreeOutsideUpCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishThreeOutsideUp(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishThreeOutsideUpCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishThreeOutsideUp(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishThreeOutsideDownCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishThreeOutsideDown(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishThreeOutsideDownCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishThreeOutsideDown(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishThreeInsideUpCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishThreeInsideUp(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishThreeInsideUpCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishThreeInsideUp(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishThreeInsideDownCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishThreeInsideDown(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishThreeInsideDownCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishThreeInsideDown(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishUpsideGapTwoCrowsCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishUpsideGapTwoCrows(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishUpsideGapTwoCrowsCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishUpsideGapTwoCrows(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishThreeWhiteSoldiersCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishThreeWhiteSoldiers(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishThreeWhiteSoldiersCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishThreeWhiteSoldiers(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishThreeBlackCrowsCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishThreeBlackCrows(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishThreeBlackCrowsCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishThreeBlackCrows(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishIdenticalThreeCrowsCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishIdenticalThreeCrows(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishIdenticalThreeCrowsCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishIdenticalThreeCrows(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 三本足【指標】継続【信頼性】中 */

	@Test()
	public void testBullishUpsideTasukiGapCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishUpsideTasukiGap(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishUpsideTasukiGapCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishUpsideTasukiGap(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDownsideTasukiGapCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishDownsideTasukiGap(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDownsideTasukiGapCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishDownsideTasukiGap(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishUpsideGapThreeMethodsCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishUpsideGapThreeMethods(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishUpsideGapThreeMethodsCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishUpsideGapThreeMethods(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDownsideGapThreeMethodsCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishDownsideGapThreeMethods(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishDownsideGapThreeMethodsCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishDownsideGapThreeMethods(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishSideBySideWhiteLinesCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishSideBySideWhiteLines(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishSideBySideWhiteLinesCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishSideBySideWhiteLines(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 三本足【指標】継続【信頼性】高 */

	@Test()
	public void testBullishSideBySideWhiteLinesCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishSideBySideWhiteLines(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishSideBySideWhiteLinesCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishSideBySideWhiteLines(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 四本足【指標】反転【信頼性】高 */

	@Test()
	public void testBullishConcealingBabySwallowCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishConcealingBabySwallow(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishConcealingBabySwallowCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishConcealingBabySwallow(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 四本足【指標】継続【信頼性】低 */

	@Test()
	public void testBullishThreeLineStrikeCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishThreeLineStrike(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishThreeLineStrikeCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishThreeLineStrike(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishThreeLineStrikeCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishThreeLineStrike(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishThreeLineStrikeCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishThreeLineStrike(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishThreeGapsCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishThreeGaps(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishThreeGapsCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishThreeGaps(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishThreeGapsCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishThreeGaps(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishThreeGapsCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishThreeGaps(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 五本足【指標】反転【信頼性】中 */

	@Test()
	public void testBullishBreakawayCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishBreakaway(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishBreakawayCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishBreakaway(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishBreakawayCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishBreakaway(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishBreakawayCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishBreakaway(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishLadderBottomCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishLadderBottom(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishLadderBottomCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishLadderBottom(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	/* ---------------------------------------------------------------------- */
	/* 五本足【指標】継続【信頼性】高 */

	@Test()
	public void testBullishRisingThreeMethodsCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishRisingThreeMethods(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishRisingThreeMethodsCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishRisingThreeMethods(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishFallingThreeMethodsCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bearishFallingThreeMethods(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBearishFallingThreeMethodsCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bearishFallingThreeMethods(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishMatHoldCandlestickArray() {
		final boolean[] b = CandlestickPatterns.bullishMatHold(c);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

	@Test()
	public void testBullishMatHoldCandlestickArrayBoolean() {
		final boolean[] b = CandlestickPatterns.bullishMatHold(c, false);
		assertNotNull(b);
		assertTrue(b.length > 0);
	}

}
