/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.backtest;

import java.util.EventObject;

import jp.sf.orangesignal.trading.stats.Stats;

/**
 * バックテスト進行状況を表すイベント情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public class BacktesterEvent extends EventObject {

	private static final long serialVersionUID = -5559788381825862392L;

	/**
	 * コンストラクタです。
	 * 
	 * @param source イベントの発生元のオブジェクト
	 * @param max データセットの数
	 * @param count データセットの処理数
	 * @param symbol 処理対象データセットのシンボル
	 * @param symbolName 処理対象データセットのシンボル名
	 * @param stats 処理対象のパフォーマンス統計情報
	 */
	public BacktesterEvent(
			final Object source,
			final int max,
			final int count,
			final String symbol,
			final String symbolName,
			final Stats stats)
	{
		super(source);
		this.max = max;
		this.count = count;
		this.symbol = symbol;
		this.symbolName = symbolName;
		this.stats = stats;
	}

	/**
	 * データセットの数を保持します。
	 */
	protected int max;

	/**
	 * データセットの数を返します。
	 * 
	 * @return データセット
	 */
	public int getMax() { return max; }

	/**
	 * データセットの処理数を保持します。
	 */
	protected int count;

	/**
	 * データセットの処理数を返します。
	 * 
	 * @return データセットの処理数
	 */
	public int getCount() { return count; }

	/**
	 * 処理対象データセットのシンボルを保持します。
	 */
	protected String symbol;

	/**
	 * 処理対象データセットのシンボルを返します。
	 * 
	 * @return 処理対象データセットのシンボル
	 */
	public String getSymbol() { return symbol; }

	/**
	 * 処理対象データセットのシンボル名を保持します。
	 */
	protected String symbolName;

	/**
	 * 処理対象データセットのシンボル名を返します。
	 * 
	 * @return 処理対象データセットのシンボル名
	 */
	public String getSymbolName() { return symbolName; }

	/**
	 * 処理対象のパフォーマンス統計情報を保持します。
	 */
	protected Stats stats;

	/**
	 * 処理対象のパフォーマンス統計情報を返します。
	 * 
	 * @return 処理対象のパフォーマンス統計情報。又は <code>null</code>
	 */
	public Stats getStats() { return stats; }

}
