/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.csv;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.regex.Pattern;

import org.junit.Ignore;
import org.junit.Test;

/**
 * {@link CsvConfig} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class CsvConfigTest {

	@Test
	public void testCsvConfig() {
		new CsvConfig();
	}

	@Test
	public void testCsvConfigChar() {
		new CsvConfig('\t');
	}

	@Test
	public void testCsvConfigCharCharChar() {
		new CsvConfig('\t', '\'', '|');
	}

	@Test
	public void testCsvConfigCharCharCharBooleanBoolean() {
		new CsvConfig('\t', '\'', '|', false, false);
	}

	@Ignore
	@Test
	public void testValidate() {
		fail("まだ実装されていません");
	}

	@Test
	public void testGetSeparator() {
		assertThat(new CsvConfig().getSeparator(), is(','));
	}

	@Test
	public void testSetSeparator() {
		final CsvConfig cfg = new CsvConfig();
		cfg.setSeparator('\t');
		assertThat(cfg.getSeparator(), is('\t'));
	}

	@Test
	public void testGetQuote() {
		assertThat(new CsvConfig().getQuote(), is('"'));
	}

	@Test
	public void testSetQuote() {
		final CsvConfig cfg = new CsvConfig();
		cfg.setQuote('\u0000');
		assertThat(cfg.getQuote(), is('\u0000'));
	}

	@Test
	public void testGetEscape() {
		assertThat(new CsvConfig().getEscape(), is('\\'));
	}

	@Test
	public void testSetEscape() {
		final CsvConfig cfg = new CsvConfig();
		cfg.setEscape('"');
		assertThat(cfg.getEscape(), is('"'));
	}

	@Test
	public void testIsQuoteDisabled() {
		assertTrue(new CsvConfig().isQuoteDisabled());
	}

	@Test
	public void testSetQuoteDisabled() {
		final CsvConfig cfg = new CsvConfig();
		cfg.setQuoteDisabled(false);
		assertFalse(cfg.isQuoteDisabled());
	}

	@Test
	public void testIsEscapeDisabled() {
		assertTrue(new CsvConfig().isEscapeDisabled());
	}

	@Test
	public void testSetEscapeDisabled() {
		final CsvConfig cfg = new CsvConfig();
		cfg.setEscapeDisabled(false);
		assertFalse(cfg.isEscapeDisabled());
	}

	@Test
	public void testGetBreakString() {
		final CsvConfig cfg = new CsvConfig();
		assertNull(cfg.getBreakString());
	}

	@Test
	public void testSetBreakString() {
		final CsvConfig cfg = new CsvConfig();
		cfg.setBreakString("\n");
		assertThat(cfg.getBreakString(), is("\n"));
	}

	@Test
	public void testGetNullString() {
		final CsvConfig cfg = new CsvConfig();
		assertNull(cfg.getNullString());
		assertThat(cfg.isIgnoreCaseNullString(), is(false));
	}

	@Test
	public void testSetNullStringString() {
		final CsvConfig cfg = new CsvConfig();
		cfg.setNullString("null");
		assertThat(cfg.getNullString(), is("null"));
		assertThat(cfg.isIgnoreCaseNullString(), is(false));
	}

	@Test
	public void testSetNullStringStringBoolean() {
		final CsvConfig cfg = new CsvConfig();
		cfg.setNullString("null", true);
		assertThat(cfg.getNullString(), is("null"));
		assertThat(cfg.isIgnoreCaseNullString(), is(true));
	}

	@Test
	public void testIsIgnoreLeadingWhitespaces() {
		assertFalse(new CsvConfig().isIgnoreLeadingWhitespaces());
	}

	@Test
	public void testSetIgnoreLeadingWhitespaces() {
		final CsvConfig cfg = new CsvConfig();
		cfg.setIgnoreLeadingWhitespaces(true);
		assertTrue(cfg.isIgnoreLeadingWhitespaces());
	}

	@Test
	public void testIsIgnoreTrailingWhitespaces() {
		assertFalse(new CsvConfig().isIgnoreTrailingWhitespaces());
	}

	@Test
	public void testSetIgnoreTrailingWhitespaces() {
		final CsvConfig cfg = new CsvConfig();
		cfg.setIgnoreTrailingWhitespaces(true);
		assertTrue(cfg.isIgnoreTrailingWhitespaces());
	}

	@Test
	public void testIsIgnoreEmptyLines() {
		assertFalse(new CsvConfig().isIgnoreEmptyLines());
	}

	@Test
	public void testSetIgnoreEmptyLines() {
		final CsvConfig cfg = new CsvConfig();
		cfg.setIgnoreEmptyLines(true);
		assertTrue(cfg.isIgnoreEmptyLines());
	}

	@Test
	public void testGetIgnoreLinePatterns() {
		assertNull(new CsvConfig().getIgnoreLinePatterns());
	}

	@Test
	public void testSetIgnoreLinePatterns() {
		final Pattern pattern = Pattern.compile("^#[ ]*$");
		final CsvConfig cfg = new CsvConfig();
		cfg.setIgnoreLinePatterns(pattern);
		assertThat(cfg.getIgnoreLinePatterns().length, is(1));
		assertThat(cfg.getIgnoreLinePatterns()[0], is(pattern));
	}

	@Test
	public void testGetSkipLines() {
		assertThat(new CsvConfig().getSkipLines(), is(0));
	}

	@Test
	public void testSetSkipLines() {
		final CsvConfig cfg = new CsvConfig();
		cfg.setSkipLines(2);
		assertThat(cfg.getSkipLines(), is(2));
	}

	@Test
	public void testGetLineSeparator() {
		assertThat(new CsvConfig().getLineSeparator(), is(System.getProperty("line.separator")));
	}

	@Test
	public void testSetLineSeparator() {
		final CsvConfig cfg = new CsvConfig();
		cfg.setLineSeparator("\n");
		assertThat(cfg.getLineSeparator(), is("\n"));
	}

}
