/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.axis;

import java.util.Date;

import jp.sf.orangesignal.chart.util.StringManager;

/**
 * 日付の目盛り単位情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum DateTickUnit {

	/**
	 * 1ヶ月毎
	 */
	ONE_MONTH {
		@Override
		public String valueToString(final Date date) {
			return String.format(StringManager.getString("format.1month"), date);
		}
	},

	/**
	 * クオータ毎
	 */
	THREE_MONTH {
		@Override
		public String valueToString(final Date date) {
			return String.format(StringManager.getString("format.3month"), date);
		}
	},

	/**
	 * 半期毎
	 */
	SIX_MONTH {
		@Override
		public String valueToString(final Date date) {
			return String.format(StringManager.getString("format.6month"), date);
		}
	},

	/**
	 * 年毎
	 */
	ONE_YEAR {
		@Override
		public String valueToString(final Date date) {
			return String.format(StringManager.getString("format.1year"), date);
		}
	};

	/**
	 * 値に対する文字列表現を返します。
	 * 
	 * @param date 日付
	 * @return 文字列
	 */
	public abstract String valueToString(Date date);

}
