/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertThat;

import java.util.Locale;
import java.util.TimeZone;

import org.junit.Test;

/**
 * {@link DateFormatConfig} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class DateFormatConfigTest {

	@Test
	public void testDateFormatConfig() {
		new DateFormatConfig();
	}

	@Test
	public void testDateFormatConfigStringLocaleTimeZone() {
		new DateFormatConfig("yyyy/MM/dd", null, null);
		new DateFormatConfig("yyyy/MM/dd HH:mm:ss", null, null);
		new DateFormatConfig("yyyy/MM/dd HH:mm:ss.SSS", null, null);
		new DateFormatConfig("yyyy/MM/dd HH:mm:ss.SSS", Locale.JAPAN, null);
		new DateFormatConfig("yyyy/MM/dd HH:mm:ss.SSS", Locale.JAPAN, TimeZone.getTimeZone("Asia/Tokyo"));
		new DateFormatConfig("yyyy/MM/dd HH:mm:ss", Locale.JAPAN, TimeZone.getTimeZone("America/New_York"));
		new DateFormatConfig("yyyy/MM/dd HH:mm:ss", Locale.JAPAN, TimeZone.getTimeZone("Russia/Moscow"));
	}

	@Test(expected = IllegalArgumentException.class)
	public void testDateFormatConfigStringLocaleTimeZoneIllegalArgumentException1() {
		new DateFormatConfig(null, null, null);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testDateFormatConfigStringLocaleTimeZoneIllegalArgumentException2() {
		new DateFormatConfig("", null, null);
	}

	@Test
	public void testGetPattern() {
		final DateFormatConfig config1 = new DateFormatConfig("yyyy/MM/dd", null, null);
		assertThat(config1.getPattern(), is("yyyy/MM/dd"));
		final DateFormatConfig config2 = new DateFormatConfig("yyyy/MM/dd HH:mm:ss.SSS", Locale.JAPAN, TimeZone.getTimeZone("Asia/Tokyo"));
		assertThat(config2.getPattern(), is("yyyy/MM/dd HH:mm:ss.SSS"));
	}

	@Test
	public void testGetLocale() {
		final DateFormatConfig config1 = new DateFormatConfig("yyyy/MM/dd", null, null);
		assertNull(config1.getLocale());
		final DateFormatConfig config2 = new DateFormatConfig("yyyy/MM/dd HH:mm:ss.SSS", Locale.JAPAN, TimeZone.getTimeZone("Asia/Tokyo"));
		assertThat(config2.getLocale().getCountry(), is("JP"));
	}

	@Test
	public void testGetTimeZone() {
		final DateFormatConfig config1 = new DateFormatConfig("yyyy/MM/dd", null, null);
		assertNull(config1.getTimeZone());
		final DateFormatConfig config2 = new DateFormatConfig("yyyy/MM/dd HH:mm:ss.SSS", Locale.JAPAN, TimeZone.getTimeZone("Asia/Tokyo"));
		assertThat(config2.getTimeZone().getID(), is("Asia/Tokyo"));
	}

}
