/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */
package jp.sf.orangesignal.ta.data.sample;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;

import jp.sf.orangesignal.ta.data.CompressType;
import jp.sf.orangesignal.ta.data.annotation.DateItem;
import jp.sf.orangesignal.ta.data.annotation.NumberCompressorType;
import jp.sf.orangesignal.ta.data.annotation.NumberItem;

public class SimpleDataset implements Serializable {

	private static final long serialVersionUID = 6140715427093129100L;

	@DateItem
	private LinkedList<Date> date;

	@NumberItem
	@NumberCompressorType(CompressType.FIRST)
	private LinkedList<Number> open;

	@NumberItem
	@NumberCompressorType(CompressType.HIGHEST)
	private LinkedList<Number> high;

	@NumberItem
	@NumberCompressorType(CompressType.LOWEST)
	private LinkedList<Number> low;

	@NumberItem
	@NumberCompressorType(CompressType.LAST)
	private LinkedList<Number> close;

	@NumberItem
	@NumberCompressorType(CompressType.SUM)
	private LinkedList<Number> volume;

	/**
	 * デフォルトコンストラクタです。
	 */
	public SimpleDataset() {}

	public LinkedList<Date> getDate() { return date; }
	public void setDate(final LinkedList<Date> date) { this.date = date; }

	public LinkedList<Number> getOpen() { return open; }
	public void setOpen(final LinkedList<Number> open) { this.open = open; }

	public LinkedList<Number> getHigh() { return high; }
	public void setHigh(final LinkedList<Number> high) { this.high = high; }

	public LinkedList<Number> getLow() { return low; }
	public void setLow(final LinkedList<Number> low) { this.low = low; }

	public LinkedList<Number> getClose() { return close; }
	public void setClose(final LinkedList<Number> colse) { this.close = colse; }

	public LinkedList<Number> getVolume() { return volume; }
	public void setVolume(final LinkedList<Number> volume) { this.volume = volume; }

}
