/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading;

/**
 * 口座情報のインターフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface Account {

	/**
	 * 残高を返します。
	 * 
	 * @return 残高
	 */
	public double getCash();

	/**
	 * 金利を返します。
	 * 
	 * @return 金利
	 */
	public double getInterestRate();

	/**
	 * 預金します。
	 * 
	 * @param amount 入金額
	 * @throws IllegalArgumentException 入金額に <code>0</code> 以下の値が指定された場合
	 */
	public void deposit(double amount);

	/**
	 * 引出します。
	 * 
	 * @param amount 出金額
	 * @return 引出せたかどうか
	 * @throws IllegalArgumentException 出金額に <code>0</code> 以下の値が指定された場合
	 */
	public boolean withdraw(final double amount);

}