/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.strategy.systems;

import static jp.sf.orangesignal.ta.Histogram.HISTOGRAM;
import static jp.sf.orangesignal.ta.TechnicalAnalysis.cross;
import static jp.sf.orangesignal.ta.TechnicalAnalysis.macd;

import java.util.Map;

import jp.sf.orangesignal.ta.CrossSignal;
import jp.sf.orangesignal.ta.Histogram;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

public abstract class MACD extends TradingStrategySupport {

	private int fast = 12;
	public int getFast() { return fast; }
	public void setFast(final int fast) { this.fast = fast; }

	private int slow = 26;
	public int getSlow() { return slow; }
	public void setSlow(final int slow) { this.slow = slow; }

	private int signal = 9;
	public int getSignal() { return signal; }
	public void setSignal(final int signal) { this.signal = signal; }

	// ----------------------------------------------------------------------

	protected CrossSignal[] cross;

	@Override
	public void prepare() {
		final Map<Histogram, Number[]> map = macd(getDataset().getTechnicalClose(), fast, slow, signal);
		final Number[] histogram = map.get(HISTOGRAM);
		this.cross = cross(histogram, 0);
	}

	@Override
	public void close() {
		this.cross = null;
	}

}
