/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart;

import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import jp.sf.orangesignal.chart.ChartColor;
import jp.sf.orangesignal.chart.axis.DateAxis;
import jp.sf.orangesignal.chart.axis.DateTickUnit;
import jp.sf.orangesignal.chart.axis.NumberAxis;
import jp.sf.orangesignal.chart.data.BasicChartDataset;
import jp.sf.orangesignal.chart.ui.DatasetType;
import jp.sf.orangesignal.chart.ui.UpDownColorType;

public class MiniChart {
    private final DateAxis dateAxis = new DateAxis();
    private Rectangle2D chartArea = null;
    private static final int PRICE = 0;
    private static final int VOLUME = 1;
    private final NumberAxis[] axes = new NumberAxis[2];
    private final Rectangle2D[] areas = new Rectangle2D[2];
    private BasicChartDataset dataset = null;
    public int start;
    public int period;
    private static final int MARGIN = 6;
    private static final double ITEM_WIDTH_FACTOR = 0.6428571428571429;
    private double periodWidth;
    private double itemWidth;

    public MiniChart() {
        this.dateAxis.setTickUnit(DateTickUnit.ONE_MONTH);
        for (int i = 0; i < this.axes.length; ++i) {
            this.axes[i] = new NumberAxis();
        }
        this.axes[0].setUpperPadding(0.05);
        this.axes[0].setLowerPadding(0.05);
        this.axes[1].setFixedLower(new Double(0.0));
        this.axes[1].setUpperPadding(0.05);
    }

    public void setDataset(BasicChartDataset dataset, int start, int period) {
        this.dataset = dataset;
        this.start = start;
        this.period = period;
        this.dateAxis.prepare(DatasetType.DAILY, this.period);
        if (this.dataset != null) {
            this.axes[0].prepare(new Number[][]{this.dataset.high, this.dataset.low});
            if (this.dataset.volume != null) {
                this.axes[1].prepare(new Number[][]{this.dataset.volume});
            }
        }
    }

    private void adjustTicks() {
        if (this.dataset != null) {
            for (NumberAxis axis : this.axes) {
                axis.autoAdjustRange(this.start, this.period);
                axis.refreshTicks();
            }
        }
    }

    private void draw(Graphics2D g2, Rectangle2D area) {
        this.processLayout(g2, area);
        this.adjustTicks();
        for (int i = 0; i < this.areas.length; ++i) {
            this.axes[i].draw(g2, this.areas[i]);
        }
        this.dateAxis.draw(g2, this.chartArea, this.areas, this.periodWidth, this.dataset.date, this.start, this.period);
        if (this.dataset != null) {
            this.drawChart(g2);
        }
    }

    private void processLayout(Graphics2D g2, Rectangle2D chartArea) {
        double basePlotWidth;
        int axisWidth = this.axes[0].getSpace(g2);
        int axisHeight = this.dateAxis.getSpace(g2);
        int x = 6 + axisWidth;
        double plotWidth = basePlotWidth = chartArea.getWidth() - (double)x - 6.0;
        double plotHeight = chartArea.getHeight() - (double)axisHeight;
        FontMetrics fm = g2.getFontMetrics(NumberAxis.FONT);
        double marginHeight = (double)fm.getAscent() * 0.5 + (double)fm.getDescent();
        int count = 2;
        this.chartArea = new Rectangle2D.Double(x, marginHeight, plotWidth, plotHeight - marginHeight);
        double chartHeight = Math.min(plotHeight / (double)count, plotHeight * 0.2);
        double _x = this.chartArea.getMinX();
        double _width = this.chartArea.getWidth();
        double _height = chartHeight - marginHeight;
        double y = this.addChartArea(0, _x, 0.0, _width, plotHeight - chartHeight * (double)(count - 1) - marginHeight, marginHeight);
        this.addChartArea(1, _x, y, _width, _height, marginHeight);
        for (int i = 0; i < this.areas.length; ++i) {
            this.axes[i].refreshTicks(g2, this.areas[i]);
        }
        this.periodWidth = (this.areas[0].getWidth() - 1.0) / (double)this.period;
        this.itemWidth = this.periodWidth * 0.6428571428571429;
    }

    private double addChartArea(int index, double x, double y, double width, double height, double marginTop) {
        this.areas[index] = new Rectangle2D.Double(x, y + marginTop, width, height);
        return this.areas[index].getMaxY();
    }

    private void drawChart(Graphics2D g2) {
        Shape saved = g2.getClip();
        if (this.areas[0] != null) {
            g2.setClip(this.areas[0]);
            this.drawCandlestick(g2);
        }
        if (this.areas[1] != null) {
            g2.setClip(this.areas[1]);
            this.drawVolume(g2);
        }
        g2.setClip(saved);
    }

    private void drawCandlestick(Graphics2D g2) {
        Rectangle2D priceArea = this.areas[0];
        NumberAxis priceAxis = this.axes[0];
        UpDownColorType colors = UpDownColorType.RED_BLUE;
        for (int i = 0; i < this.period; ++i) {
            int n = this.start + i;
            if (n < 0 || n >= this.dataset.getCount() || this.dataset.open[n] == null) continue;
            double openY = priceAxis.valueToJava2D(this.dataset.open[n].doubleValue(), priceArea);
            double highY = priceAxis.valueToJava2D(this.dataset.high[n].doubleValue(), priceArea);
            double lowY = priceAxis.valueToJava2D(this.dataset.low[n].doubleValue(), priceArea);
            double closeY = priceAxis.valueToJava2D(this.dataset.close[n].doubleValue(), priceArea);
            double maxOpenCloseY = Math.max(openY, closeY);
            double minOpenCloseY = Math.min(openY, closeY);
            boolean down = closeY > openY;
            double x = priceArea.getMinX() + (double)i * this.periodWidth + this.periodWidth * 0.5;
            g2.setColor(down ? colors.getDownLineColor() : colors.getUpLineColor());
            g2.draw(new Line2D.Double(x, highY, x, maxOpenCloseY));
            g2.draw(new Line2D.Double(x, lowY, x, minOpenCloseY));
            double x1 = priceArea.getMinX() + (double)i * this.periodWidth + (this.periodWidth - this.itemWidth) * 0.5;
            double x2 = x1 + this.itemWidth;
            if (down) {
                g2.setPaint(new GradientPaint((float)x1, (float)minOpenCloseY, colors.getDownColor1(), (float)x2, (float)maxOpenCloseY, colors.getDownColor2()));
            } else {
                g2.setPaint(new GradientPaint((float)x1, (float)minOpenCloseY, colors.getUpColor1(), (float)x2, (float)maxOpenCloseY, colors.getUpColor2()));
            }
            Rectangle2D.Double body = new Rectangle2D.Double(x1, minOpenCloseY, x2 - x1, maxOpenCloseY - minOpenCloseY);
            g2.fill(body);
            g2.setColor(down ? colors.getDownLineColor() : colors.getUpLineColor());
            g2.draw(body);
        }
    }

    private void drawVolume(Graphics2D g2) {
        Rectangle2D volumeArea = this.areas[1];
        NumberAxis volumeAxis = this.axes[1];
        for (int i = 0; i < this.period; ++i) {
            int n = this.start + i;
            if (n < 0 || n >= this.dataset.getCount() || this.dataset.volume[n] == null) continue;
            double volumeY = volumeAxis.valueToJava2D(this.dataset.volume[n].doubleValue(), volumeArea);
            double x1 = volumeArea.getMinX() + (double)i * this.periodWidth;
            g2.setPaint(new GradientPaint((float)x1, (float)volumeY, ChartColor.GREEN, (float)(x1 + this.periodWidth), (float)volumeArea.getMaxY(), ChartColor.DARK_GREEN));
            Rectangle2D.Double bar = new Rectangle2D.Double(x1, volumeY, this.periodWidth, volumeArea.getMaxY() - volumeY);
            g2.fill(bar);
        }
    }

    public BufferedImage createBufferedImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g2.setColor(ChartColor.WHITE);
        g2.fillRect(0, 0, width, height);
        this.draw(g2, new Rectangle(0, 0, width, height));
        g2.dispose();
        return image;
    }
}

