/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.data;

import java.util.Date;
import java.util.List;
import jp.sf.orangesignal.chart.data.ChartDataset;
import jp.sf.orangesignal.ta.result.Step;
import jp.sf.orangesignal.ta.util.Assert;

public class StepChartDataset
implements ChartDataset {
    public Date[] startDate;
    public Number[] start;
    public Date[] highDate;
    public Number[] high;
    public Date[] lowDate;
    public Number[] low;
    public Date[] endDate;
    public Number[] end;
    public int[] period;
    public double point;

    public StepChartDataset(List<Step> list) {
        this(list, 0.0);
    }

    public StepChartDataset(List<Step> list, double point) {
        Assert.notNull(list, (String)"Step list must not be null");
        Assert.isTrue((point >= 0.0 ? 1 : 0) != 0);
        int length = list.size();
        this.startDate = new Date[length];
        this.start = new Number[length];
        this.highDate = new Date[length];
        this.high = new Number[length];
        this.lowDate = new Date[length];
        this.low = new Number[length];
        this.endDate = new Date[length];
        this.end = new Number[length];
        this.period = new int[length];
        for (int i = 0; i < list.size(); ++i) {
            Step step = list.get(i);
            this.startDate[i] = step.openDate;
            this.start[i] = step.open;
            this.highDate[i] = step.highDate;
            this.high[i] = step.high;
            this.lowDate[i] = step.lowDate;
            this.low[i] = step.low;
            this.endDate[i] = step.closeDate;
            this.end[i] = step.close;
            this.period[i] = step.period;
        }
        this.point = point;
    }

    @Override
    public int getCount() {
        return this.startDate == null ? 0 : this.startDate.length;
    }
}

