/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.data;

import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.data.BasicChartDataset;
import jp.sf.orangesignal.chart.ui.BandType;
import jp.sf.orangesignal.chart.ui.ChartScreenType;
import jp.sf.orangesignal.chart.ui.DatasetType;
import jp.sf.orangesignal.chart.ui.PeriodType;
import jp.sf.orangesignal.chart.ui.PriceChartType;
import jp.sf.orangesignal.chart.ui.VolumeType;
import jp.sf.orangesignal.chart.unit.BidAndOfferUnits;
import jp.sf.orangesignal.ta.MovingAverage;
import jp.sf.orangesignal.ta.PercentageScale;
import jp.sf.orangesignal.ta.TechnicalAnalysis;
import jp.sf.orangesignal.ta.candle.Candlestick;
import jp.sf.orangesignal.ta.candle.CandlestickPatterns;
import jp.sf.orangesignal.ta.candle.generator.CandlestickGenerator;
import jp.sf.orangesignal.ta.candle.generator.KagiTrendProcessor;
import jp.sf.orangesignal.ta.candle.generator.PointFigureTrendProcessor;
import jp.sf.orangesignal.ta.candle.generator.RenkohTrendProcessor;
import jp.sf.orangesignal.ta.candle.generator.ShinneTrendProcessor;
import jp.sf.orangesignal.ta.candle.generator.TrendProcessor;
import jp.sf.orangesignal.ta.result.Aroon;
import jp.sf.orangesignal.ta.result.Bands2;
import jp.sf.orangesignal.ta.result.Bands5;
import jp.sf.orangesignal.ta.result.Bands7;
import jp.sf.orangesignal.ta.result.DMI;
import jp.sf.orangesignal.ta.result.FourPrice;
import jp.sf.orangesignal.ta.result.Histogram;
import jp.sf.orangesignal.ta.result.Ichimoku;
import jp.sf.orangesignal.ta.result.MESA;
import jp.sf.orangesignal.ta.result.Shinohara;
import jp.sf.orangesignal.ta.result.Step;
import jp.sf.orangesignal.ta.result.Stochastics;
import jp.sf.orangesignal.ta.util.DateArrayUtils;

public class TimeSeriesChartDataset
extends BasicChartDataset {
    public Number[] avgprice;
    public Number[] mp;
    public Number[] tp;
    public Number[] wc;
    public Number[] zigzag;
    public List<Step> kagi;
    public boolean[] bullishLongWhiteDay;
    public boolean[] bullishBeltHold;
    public boolean[] bullishHammer;
    public boolean[] bullishDragonflyDoji;
    public boolean[] bullishLongLeggedDoji;
    public boolean[] bullishInvertedHammer;
    public boolean[] bullishHarami;
    public boolean[] bullishHaramiCross;
    public boolean[] bullishEngulfing;
    public boolean[] bullishGravestoneDoji;
    public boolean[] bullishMeetingLines;
    public boolean[] bullishDojiStar;
    public boolean[] bullishHomingPigeon;
    public boolean[] bullishMatchingLow;
    public boolean[] bullishTweezerBottom;
    public boolean[] bullishKicking;
    public boolean[] bullishPiercingLine;
    public boolean[] bullishSeparatingLines;
    public boolean[] bullishTriStar;
    public boolean[] bullishThreeStarsInTheSouth;
    public boolean[] bullishUniqueThreeRiverBottom;
    public boolean[] bullishStickSandwich;
    public boolean[] bullishAbandonedBaby;
    public boolean[] bullishMorningDojiStar;
    public boolean[] bullishMorningStar;
    public boolean[] bullishThreeOutsideUp;
    public boolean[] bullishThreeInsideUp;
    public boolean[] bullishThreeWhiteSoldiers;
    public boolean[] bullishUpsideTasukiGap;
    public boolean[] bullishUpsideGapThreeMethods;
    public boolean[] bullishSideBySideWhiteLines;
    public boolean[] bullishConcealingBabySwallow;
    public boolean[] bullishThreeLineStrike;
    public boolean[] bullishThreeGaps;
    public boolean[] bullishBreakaway;
    public boolean[] bullishLadderBottom;
    public boolean[] bullishRisingThreeMethods;
    public boolean[] bullishMatHold;
    public boolean[] bearishLongBlackDay;
    public boolean[] bearishBeltHold;
    public boolean[] bearishHangingMan;
    public boolean[] bearishDragonflyDoji;
    public boolean[] bearishLongLeggedDoji;
    public boolean[] bearishShootingStar;
    public boolean[] bearishHarami;
    public boolean[] bearishHaramiCross;
    public boolean[] bearishEngulfing;
    public boolean[] bearishGravestoneDoji;
    public boolean[] bearishMeetingLines;
    public boolean[] bearishDojiStar;
    public boolean[] bearishDescendingHawk;
    public boolean[] bearishMatchingHigh;
    public boolean[] bearishTweezerTop;
    public boolean[] bearishKicking;
    public boolean[] bearishDarkCloudCover;
    public boolean[] bearishSeparatingLines;
    public boolean[] bearishThrusting;
    public boolean[] bearishOnNeck;
    public boolean[] bearishInNeck;
    public boolean[] bearishTriStar;
    public boolean[] bearishTwoCrows;
    public boolean[] bearishAdvanceBlock;
    public boolean[] bearishDeliberation;
    public boolean[] bearishAbandonedBaby;
    public boolean[] bearishEveningDojiStar;
    public boolean[] bearishEveningStar;
    public boolean[] bearishThreeOutsideDown;
    public boolean[] bearishThreeInsideDown;
    public boolean[] bearishUpsideGapTwoCrows;
    public boolean[] bearishThreeBlackCrows;
    public boolean[] bearishIdenticalThreeCrows;
    public boolean[] bearishDownsideTasukiGap;
    public boolean[] bearishDownsideGapThreeMethods;
    public boolean[] bearishSideBySideWhiteLines;
    public boolean[] bearishThreeLineStrike;
    public boolean[] bearishThreeGaps;
    public boolean[] bearishBreakaway;
    public boolean[] bearishFallingThreeMethods;
    public Number[] ma1;
    public Number[] ma2;
    public Number[] ma_bias;
    public Number[] lr1_upper2;
    public Number[] lr1_upper1;
    public Number[] lr1;
    public Number[] lr1_lower1;
    public Number[] lr1_lower2;
    public Number[] lr2_upper2;
    public Number[] lr2_upper1;
    public Number[] lr2;
    public Number[] lr2_lower1;
    public Number[] lr2_lower2;
    public Number[] bb_upper2;
    public Number[] bb_upper1;
    public Number[] bb_tpma;
    public Number[] bb_lower1;
    public Number[] bb_lower2;
    public Number[] donchian_upper;
    public Number[] donchian_lower;
    public Number[] envelope_upper2;
    public Number[] envelope_upper1;
    public Number[] envelope;
    public Number[] envelope_lower1;
    public Number[] envelope_lower2;
    public Number[] hma;
    public Number[] lma;
    public Number[] sar;
    public Number[] pivot_hbop;
    public Number[] pivot_s2;
    public Number[] pivot_s1;
    public Number[] pivot;
    public Number[] pivot_b1;
    public Number[] pivot_b2;
    public Number[] pivot_lbop;
    public Number[] vi_upper;
    public Number[] vi_lower;
    public Number[] kijun;
    public Number[] tenkan;
    public Number[] senkou1;
    public Number[] senkou2;
    public Number[] chikou;
    public Number[] mama;
    public Number[] fama;
    public Number[] vidya;
    public Number[] aroonUp;
    public Number[] aroonDown;
    public Number[] aroon;
    public Number[] atr;
    public Number[] natr;
    public Number[] bop;
    public Number[] chv;
    public Number[] cci;
    public Number[] cmf;
    public Number[] cmo;
    public Number[] coppock;
    public Number[] crsi;
    public Number[] dpo;
    public Number[] pdi;
    public Number[] mdi;
    public Number[] adx;
    public Number[] emv;
    public Number[] hv;
    public Number[] kairi;
    public Number[] mi;
    public Number[] mom;
    public Number[] mfi;
    public Number[] macd;
    public Number[] macdSignal;
    public Number[] macdHistogram;
    public Number[] pain;
    public Number[] pcr;
    public Number[] apo;
    public Number[] ppo;
    public Number[] psy;
    public Number[] qstick;
    public Number[] rsi;
    public Number[] rvi;
    public Number[] rci;
    public Number[] roc;
    public Number[] shinohara_a;
    public Number[] shinohara_b;
    public Number[] srvK;
    public Number[] srvD;
    public Number[] srvSD;
    public Number[] tii;
    public Number[] trix;
    public Number[] trixSignal;
    public Number[] tsi;
    public Number[] tsi_signal;
    public Number[] tsi_histogram;
    public Number[] ultimate;
    public Number[] wad;
    public Number[] williamsR;
    public Number[] ad;
    public Number[] cho;
    public Number[] vma1;
    public Number[] vma2;
    public Number[] vkairi;
    public Number[] avo;
    public Number[] pvo;
    public Number[] vr1;
    public Number[] vr2;
    public Number[] vroc;
    public Number[] vrsi;
    public Number[] wvr;
    public Number[] pvi;
    public Number[] pvi_ma1;
    public Number[] pvi_ma2;
    public Number[] nvi;
    public Number[] nvi_ma1;
    public Number[] nvi_ma2;
    public Number[] obv;
    public Number[] pvt;
    public Number[] price_performance;
    public Number[] percent_performance;
    public Number[] ratiocater;

    public TimeSeriesChartDataset(BasicChartDataset dataset, DatasetType type, PeriodType periodType, ChartSettings settings) {
        super(dataset);
        Object processor;
        Map map;
        ChartSettings.TimeSeriesSettings s = settings.timeSeries;
        if (s.avgprice) {
            this.avgprice = TechnicalAnalysis.avgprice((Number[])this.techOpen, (Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose);
        }
        if (s.mp) {
            this.mp = TechnicalAnalysis.mp((Number[])this.techHigh, (Number[])this.techLow);
        }
        if (s.tp) {
            this.tp = TechnicalAnalysis.tp((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose);
        }
        if (s.wc) {
            this.wc = TechnicalAnalysis.wtcl((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose);
        }
        if (s.lr) {
            map = TechnicalAnalysis.lr((Number[])this.techClose, (int)s.lr1Period, (int)0);
            this.lr1_upper2 = (Number[])map.get(Bands5.UPPER_BAND2);
            this.lr1_upper1 = (Number[])map.get(Bands5.UPPER_BAND1);
            this.lr1 = (Number[])map.get(Bands5.MIDDLE_BAND);
            this.lr1_lower1 = (Number[])map.get(Bands5.LOWER_BAND1);
            this.lr1_lower2 = (Number[])map.get(Bands5.LOWER_BAND2);
            map = TechnicalAnalysis.lr((Number[])this.techClose, (int)s.lr2Period, (int)0);
            this.lr2_upper2 = (Number[])map.get(Bands5.UPPER_BAND2);
            this.lr2_upper1 = (Number[])map.get(Bands5.UPPER_BAND1);
            this.lr2 = (Number[])map.get(Bands5.MIDDLE_BAND);
            this.lr2_lower1 = (Number[])map.get(Bands5.LOWER_BAND1);
            this.lr2_lower2 = (Number[])map.get(Bands5.LOWER_BAND2);
        }
        if (s.ma) {
            this.ma1 = TechnicalAnalysis.ma((Number[])this.techClose, (int)s.ma1Period, (MovingAverage)s.maType.getMovingAverage());
            this.ma2 = TechnicalAnalysis.ma((Number[])this.techClose, (int)s.ma2Period, (MovingAverage)s.maType.getMovingAverage());
            if (s.ma1Period > s.ma2Period) {
                this.ma_bias = TechnicalAnalysis.kairi((Number[])this.ma2, (Number[])this.ma1);
            } else if (s.ma1Period < s.ma2Period) {
                this.ma_bias = TechnicalAnalysis.kairi((Number[])this.ma1, (Number[])this.ma2);
            }
        }
        if (s.zigzag) {
            this.zigzag = TechnicalAnalysis.zigzag((Number[])this.close, (double)s.zigzag_rate);
        }
        if (s.bandType == BandType.ENVELOPE) {
            map = TechnicalAnalysis.envelope((Number[])this.techClose, (int)s.envelopePeriod, (MovingAverage)s.envelopeMaType.getMovingAverage(), (double)s.envelopeRate);
            this.envelope_upper2 = (Number[])map.get(Bands5.UPPER_BAND2);
            this.envelope_upper1 = (Number[])map.get(Bands5.UPPER_BAND1);
            this.envelope = (Number[])map.get(Bands5.MIDDLE_BAND);
            this.envelope_lower1 = (Number[])map.get(Bands5.LOWER_BAND1);
            this.envelope_lower2 = (Number[])map.get(Bands5.LOWER_BAND2);
        } else if (s.bandType == BandType.HIGH_LOW_MOVING_AVERAGE) {
            this.hma = TechnicalAnalysis.ma((Number[])this.techHigh, (int)s.hmaPeriod, (MovingAverage)s.hlmaMaType.getMovingAverage());
            this.lma = TechnicalAnalysis.ma((Number[])this.techLow, (int)s.lmaPeriod, (MovingAverage)s.hlmaMaType.getMovingAverage());
        } else if (s.bandType == BandType.DONCHIAN) {
            this.donchian_upper = TechnicalAnalysis.highest((Number[])this.techHigh, (int)s.donchianPeriod);
            this.donchian_lower = TechnicalAnalysis.lowest((Number[])this.techLow, (int)s.donchianPeriod);
        } else if (s.bandType == BandType.BOLLINGER_BANDS) {
            map = TechnicalAnalysis.bbands((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (int)s.bbPeriod, (double)s.bbRate);
            this.bb_upper2 = (Number[])map.get(Bands5.UPPER_BAND2);
            this.bb_upper1 = (Number[])map.get(Bands5.UPPER_BAND1);
            this.bb_tpma = (Number[])map.get(Bands5.MIDDLE_BAND);
            this.bb_lower1 = (Number[])map.get(Bands5.LOWER_BAND1);
            this.bb_lower2 = (Number[])map.get(Bands5.LOWER_BAND2);
        } else if (s.bandType == BandType.PARABOLIC_TIME_PRICE) {
            this.sar = TechnicalAnalysis.sar((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (double)s.af);
        } else if (s.bandType == BandType.PIVOT) {
            map = TechnicalAnalysis.pivot((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose);
            this.pivot_hbop = (Number[])map.get(Bands7.UPPER_BAND3);
            this.pivot_s2 = (Number[])map.get(Bands7.UPPER_BAND2);
            this.pivot_s1 = (Number[])map.get(Bands7.UPPER_BAND1);
            this.pivot = (Number[])map.get(Bands7.MIDDLE_BAND);
            this.pivot_b1 = (Number[])map.get(Bands7.LOWER_BAND1);
            this.pivot_b2 = (Number[])map.get(Bands7.LOWER_BAND2);
            this.pivot_lbop = (Number[])map.get(Bands7.LOWER_BAND3);
        } else if (s.bandType == BandType.VIX) {
            map = TechnicalAnalysis.volatility((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (int)s.atrPeriod, (double)s.atrWeight);
            this.vi_upper = (Number[])map.get(Bands2.UPPER_BAND);
            this.vi_lower = (Number[])map.get(Bands2.LOWER_BAND);
        } else if (s.bandType == BandType.ICHIMOKU) {
            map = TechnicalAnalysis.ichimoku((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (int)s.kijunPeriod, (int)s.tenkanPeriod, (int)s.spanPeriod);
            this.kijun = (Number[])map.get(Ichimoku.KIJUN);
            this.tenkan = (Number[])map.get(Ichimoku.TENKAN);
            this.senkou1 = (Number[])map.get(Ichimoku.SENKOU1);
            this.senkou2 = (Number[])map.get(Ichimoku.SENKOU2);
            this.chikou = (Number[])map.get(Ichimoku.CHIKOU);
        } else if (s.bandType == BandType.MESA) {
            map = TechnicalAnalysis.mama((Number[])this.techClose);
            this.mama = (Number[])map.get(MESA.MAMA);
            this.fama = (Number[])map.get(MESA.FAMA);
        } else if (s.bandType == BandType.VIDYA) {
            this.vidya = TechnicalAnalysis.vidya((Number[])this.techClose, (int)s.vidya_period, (int)s.vidya_cmo_period);
        }
        if (s.aroon) {
            map = TechnicalAnalysis.aroon((Number[])this.techClose, (int)s.aroonPeriod);
            this.aroonUp = (Number[])map.get(Aroon.AROON_UP);
            this.aroonDown = (Number[])map.get(Aroon.AROON_DOWN);
            this.aroon = (Number[])map.get(Aroon.AROON);
        }
        if (s.atr) {
            this.atr = TechnicalAnalysis.atr((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (int)s.atr_period);
        }
        if (s.natr) {
            this.natr = TechnicalAnalysis.natr((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (int)s.natr_period);
        }
        if (s.bop) {
            this.bop = TechnicalAnalysis.bop((Number[])this.techOpen, (Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose);
        }
        if (s.cci) {
            this.cci = TechnicalAnalysis.cci((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (int)s.cciPeriod);
        }
        if (s.chv) {
            this.chv = TechnicalAnalysis.chv((Number[])this.techHigh, (Number[])this.techLow, (int)s.chv_period1, (int)s.chv_period2);
        }
        if (s.cmf) {
            this.cmf = TechnicalAnalysis.cmf((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (Number[])this.techVolume, (int)s.cmf_period);
        }
        if (s.cmo) {
            this.cmo = TechnicalAnalysis.cmo((Number[])this.techChange, (int)s.cmo_period);
        }
        if (s.coppock) {
            this.coppock = TechnicalAnalysis.coppock((Number[])this.techClose, (int)s.coppockRocPeriod, (int)s.coppockPeriod, (MovingAverage)s.coppockMaType.getMovingAverage());
        }
        if (s.dpo) {
            this.dpo = TechnicalAnalysis.dpo((Number[])this.techClose, (int)s.dpoPeriod, (MovingAverage)s.dpoMaType.getMovingAverage());
        }
        if (s.dmi) {
            map = TechnicalAnalysis.dmi((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (int)s.diPeriod, (int)s.adxPeriod);
            this.pdi = (Number[])map.get(DMI.PLUS_DI);
            this.mdi = (Number[])map.get(DMI.MINUS_DI);
            this.adx = (Number[])map.get(DMI.ADX);
        }
        if (s.emv) {
            this.emv = TechnicalAnalysis.emv((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techVolume, (int)s.emv_period);
        }
        if (s.hv) {
            int days;
            if (type == DatasetType.DAILY) {
                days = 250;
            } else if (type == DatasetType.WEEKLY) {
                days = 52;
            } else if (type == DatasetType.MONTHLY) {
                days = 12;
            } else {
                throw new RuntimeException();
            }
            this.hv = TechnicalAnalysis.hv((Number[])this.techClose, (int)s.hvPeriod, (int)days);
        }
        if (s.kairi) {
            this.kairi = TechnicalAnalysis.kairi((Number[])this.techClose, (Number[])TechnicalAnalysis.ma((Number[])this.techClose, (int)s.biasPeriod, (MovingAverage)s.biasMaType.getMovingAverage()));
        }
        if (s.mi) {
            this.mi = TechnicalAnalysis.mi((Number[])this.techHigh, (Number[])this.techLow, (int)s.miSumPeriod, (int)s.miMaPeriod, (MovingAverage)s.miMaType.getMovingAverage());
        }
        if (s.mom) {
            this.mom = TechnicalAnalysis.mom((Number[])this.techClose, (int)s.mom_period);
        }
        if (s.mfi) {
            this.mfi = TechnicalAnalysis.mfi((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (Number[])this.techVolume, (int)s.mfiPeriod);
        }
        if (s.macd) {
            Map map2 = TechnicalAnalysis.macd((Number[])this.techClose, (int)s.macdMa1Period, (int)s.macdMa2Period, (int)s.macdSignalPeriod, (MovingAverage)s.macdSignalMaType.getMovingAverage());
            this.macd = (Number[])map2.get(Histogram.INDICATOR);
            this.macdSignal = (Number[])map2.get(Histogram.SIGNAL);
            this.macdHistogram = (Number[])map2.get(Histogram.HISTOGRAM);
        }
        if (s.pain) {
            this.pain = TechnicalAnalysis.pain((Number[])this.techOpen, (Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose);
        }
        if (s.pcr) {
            this.pcr = TechnicalAnalysis.pcr((Number[])this.techClose, (int)s.pcr_period);
        }
        if (s.apo) {
            this.apo = TechnicalAnalysis.apo((Number[])this.techClose, (int)s.apoMa1Period, (int)s.apoMa2Period);
        }
        if (s.ppo) {
            this.ppo = TechnicalAnalysis.ppo((Number[])this.techClose, (int)s.ppoMa1Period, (int)s.ppoMa2Period);
        }
        if (s.psy) {
            this.psy = TechnicalAnalysis.psy((Number[])this.techChange, (int)s.psy_period);
        }
        if (s.qstick) {
            this.qstick = TechnicalAnalysis.qstick((Number[])this.techOpen, (Number[])this.techClose, (int)s.qstick_period, (MovingAverage)s.qstick_matype.getMovingAverage());
        }
        if (s.rci) {
            this.rci = TechnicalAnalysis.rci((Number[])this.techClose, (int)s.rciPeriod);
        }
        if (s.roc) {
            this.roc = TechnicalAnalysis.roc((Number[])this.techClose, (int)s.rocPeriod);
        }
        if (s.rsi) {
            this.rsi = TechnicalAnalysis.rsi((Number[])this.techChange, (int)s.rsiPeriod);
        }
        if (s.rvi) {
            this.rvi = TechnicalAnalysis.rvi((Number[])this.techChange, (int)s.rsiPeriod);
        }
        if (s.shinohara) {
            Map map3 = TechnicalAnalysis.shinohara((Number[])this.techOpen, (Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (int)s.shinoharaPeriod);
            this.shinohara_a = (Number[])map3.get(Shinohara.A_RATIO);
            this.shinohara_b = (Number[])map3.get(Shinohara.B_RATIO);
        }
        if (s.srv) {
            Map map4 = TechnicalAnalysis.srv((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (int)s.srvKPeriod, (int)s.srvDPeriod);
            this.srvK = (Number[])map4.get(Stochastics.K);
            this.srvD = (Number[])map4.get(Stochastics.D);
            this.srvSD = (Number[])map4.get(Stochastics.SD);
        }
        if (s.tii) {
            this.tii = TechnicalAnalysis.tii((Number[])this.techClose, (int)s.tii_period, (MovingAverage)s.tii_matype.getMovingAverage());
        }
        if (s.trix) {
            Map map5 = TechnicalAnalysis.trix((Number[])this.techClose, (int)s.trixPeriod, (int)s.trixSignalPeriod, (MovingAverage)s.trixSignalMaType.getMovingAverage());
            this.trix = (Number[])map5.get(Histogram.INDICATOR);
            this.trixSignal = (Number[])map5.get(Histogram.SIGNAL);
        }
        if (s.tsi) {
            Map map6 = TechnicalAnalysis.tsi((Number[])this.techChange, (int)s.tsi_period1, (int)s.tsi_period2, (int)s.tsi_signal_period, (MovingAverage)s.tsi_signal_matype.getMovingAverage());
            this.tsi = (Number[])map6.get(Histogram.INDICATOR);
            this.tsi_signal = (Number[])map6.get(Histogram.SIGNAL);
            this.tsi_histogram = (Number[])map6.get(Histogram.HISTOGRAM);
        }
        if (s.ultimate) {
            this.ultimate = TechnicalAnalysis.ultimate((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (int)s.ultimatePeriod);
        }
        if (s.wad) {
            this.wad = TechnicalAnalysis.wad((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose);
        }
        if (s.williamsR) {
            this.williamsR = TechnicalAnalysis.wr((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (int)s.williamsRPeriod);
        }
        if (s.ad) {
            this.ad = TechnicalAnalysis.ad((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (Number[])this.techVolume);
        }
        if (s.cho) {
            this.cho = TechnicalAnalysis.cho((Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose, (Number[])this.techVolume, (int)s.cho_fast, (MovingAverage)s.cho_matype.getMovingAverage(), (int)s.cho_slow, (MovingAverage)s.cho_matype.getMovingAverage());
        }
        if (s.volumeType == VolumeType.MOVING_AVERAGE) {
            this.vma1 = TechnicalAnalysis.ma((Number[])this.techVolume, (int)s.vma1Period, (MovingAverage)s.vmaMaType.getMovingAverage());
            this.vma2 = TechnicalAnalysis.ma((Number[])this.techVolume, (int)s.vma2Period, (MovingAverage)s.vmaMaType.getMovingAverage());
        }
        if (s.avo) {
            this.avo = TechnicalAnalysis.avo((Number[])this.techVolume, (int)s.avoMa1Period, (int)s.avoMa2Period);
        }
        if (s.pvo) {
            this.pvo = TechnicalAnalysis.pvo((Number[])this.techVolume, (int)s.pvoMa1Period, (int)s.pvoMa2Period);
        }
        if (s.vkairi) {
            this.vkairi = TechnicalAnalysis.kairi((Number[])this.techVolume, (Number[])TechnicalAnalysis.ma((Number[])this.techVolume, (int)s.vbiasPeriod, (MovingAverage)s.vbiasMaType.getMovingAverage()));
        }
        if (s.vr1) {
            this.vr1 = TechnicalAnalysis.vr1((Number[])this.techChange, (Number[])this.techVolume, (int)s.vr1Period);
        }
        if (s.vr2) {
            this.vr2 = TechnicalAnalysis.vr2((Number[])this.techChange, (Number[])this.techVolume, (int)s.vr2Period);
        }
        if (s.vroc) {
            this.vroc = TechnicalAnalysis.roc((Number[])this.techVolume, (int)s.vrocPeriod);
        }
        if (s.vrsi) {
            this.vrsi = TechnicalAnalysis.rsi((Number[])TechnicalAnalysis.chg((Number[])this.techVolume), (int)s.vrsiPeriod);
        }
        if (s.wvr) {
            this.wvr = TechnicalAnalysis.wvr((Number[])this.techChange, (Number[])this.techVolume, (int)s.wvrPeriod);
        }
        if (s.pvi) {
            this.pvi = TechnicalAnalysis.pvi((Number[])this.techClose, (Number[])this.techVolume);
            this.pvi_ma1 = TechnicalAnalysis.ma((Number[])this.pvi, (int)s.pvi_fast, (MovingAverage)s.pvi_matype.getMovingAverage());
            this.pvi_ma2 = TechnicalAnalysis.ma((Number[])this.pvi, (int)s.pvi_slow, (MovingAverage)s.pvi_matype.getMovingAverage());
        }
        if (s.nvi) {
            this.nvi = TechnicalAnalysis.nvi((Number[])this.techClose, (Number[])this.techVolume);
            this.nvi_ma1 = TechnicalAnalysis.ma((Number[])this.nvi, (int)s.nvi_fast, (MovingAverage)s.nvi_matype.getMovingAverage());
            this.nvi_ma2 = TechnicalAnalysis.ma((Number[])this.nvi, (int)s.nvi_slow, (MovingAverage)s.nvi_matype.getMovingAverage());
        }
        if (s.obv) {
            this.obv = TechnicalAnalysis.obv((Number[])this.techChange, (Number[])this.techVolume, (int)s.obvPeriod);
        }
        if (s.pvt) {
            this.pvt = TechnicalAnalysis.pvt((Number[])this.techClose, (Number[])this.techVolume);
        }
        if (s.price_performance) {
            this.price_performance = TechnicalAnalysis.performance((Number[])this.techClose, (int)DateArrayUtils.lastIndexOf((Date[])this.date, (Date)s.priceFluctuationsPeriodType.getPreviousDate(this.date[this.date.length - 1])));
        }
        if (s.percent_performance) {
            this.percent_performance = TechnicalAnalysis.performance((Number[])this.techClose, (int)DateArrayUtils.lastIndexOf((Date[])this.date, (Date)s.performancePeriodType.getPreviousDate(this.date[this.date.length - 1])), (PercentageScale)PercentageScale.PERCENT);
        }
        if (s.candleTrend == ChartScreenType.POINT_AND_FIGURE) {
            processor = new PointFigureTrendProcessor(TechnicalAnalysis.pf((Date[])this.date, (Number[])this.close, (double)settings.pf.point, (int)settings.pf.reversal));
        } else if (s.candleTrend == ChartScreenType.KAGI || s.kagi) {
            this.kagi = TechnicalAnalysis.kagi((Date[])this.date, (Number[])this.techClose, (double)s.kagi_rate);
            processor = new KagiTrendProcessor(this.kagi);
        } else if (s.candleTrend == ChartScreenType.RENKOH) {
            double avg = dataset.getMaxHighLowAverage();
            processor = new RenkohTrendProcessor(TechnicalAnalysis.renkoh((Date[])this.date, (Number[])this.close, (double)(new BidAndOfferUnits().getCeilingUnit((int)avg).getPoint() * (double)settings.renkoh.rate)));
        } else {
            processor = s.candleTrend == ChartScreenType.SHINNE ? new ShinneTrendProcessor(TechnicalAnalysis.shinne((Date[])this.date, (Number[])this.close, (int)settings.shinne.reversal)) : null;
        }
        Candlestick[] c = new CandlestickGenerator().generate(this.date, this.open, this.high, this.low, this.close, (TrendProcessor)processor);
        if (s.bullishLongWhiteDay) {
            this.bullishLongWhiteDay = CandlestickPatterns.bullishLongWhiteDay((Candlestick[])c);
        }
        if (s.bullishBeltHold) {
            this.bullishBeltHold = CandlestickPatterns.bullishBeltHold((Candlestick[])c);
        }
        if (s.bullishHammer) {
            this.bullishHammer = CandlestickPatterns.bullishHammer((Candlestick[])c);
        }
        if (s.bullishDragonflyDoji) {
            this.bullishDragonflyDoji = CandlestickPatterns.bullishDragonflyDoji((Candlestick[])c);
        }
        if (s.bullishLongLeggedDoji) {
            this.bullishLongLeggedDoji = CandlestickPatterns.bullishLongLeggedDoji((Candlestick[])c);
        }
        if (s.bullishInvertedHammer) {
            this.bullishInvertedHammer = CandlestickPatterns.bullishInvertedHammer((Candlestick[])c);
        }
        if (s.bullishHarami) {
            this.bullishHarami = CandlestickPatterns.bullishHarami((Candlestick[])c);
        }
        if (s.bullishHaramiCross) {
            this.bullishHaramiCross = CandlestickPatterns.bullishHaramiCross((Candlestick[])c);
        }
        if (s.bullishEngulfing) {
            this.bullishEngulfing = CandlestickPatterns.bullishEngulfing((Candlestick[])c);
        }
        if (s.bullishGravestoneDoji) {
            this.bullishGravestoneDoji = CandlestickPatterns.bullishGravestoneDoji((Candlestick[])c);
        }
        if (s.bullishMeetingLines) {
            this.bullishMeetingLines = CandlestickPatterns.bullishMeetingLines((Candlestick[])c);
        }
        if (s.bullishDojiStar) {
            this.bullishDojiStar = CandlestickPatterns.bullishDojiStar((Candlestick[])c);
        }
        if (s.bullishHomingPigeon) {
            this.bullishHomingPigeon = CandlestickPatterns.bullishHomingPigeon((Candlestick[])c);
        }
        if (s.bullishMatchingLow) {
            this.bullishMatchingLow = CandlestickPatterns.bullishMatchingLow((Candlestick[])c);
        }
        if (s.bullishTweezerBottom) {
            this.bullishTweezerBottom = CandlestickPatterns.bullishTweezerBottom((Candlestick[])c);
        }
        if (s.bullishKicking) {
            this.bullishKicking = CandlestickPatterns.bullishKicking((Candlestick[])c);
        }
        if (s.bullishPiercingLine) {
            this.bullishPiercingLine = CandlestickPatterns.bullishPiercingLine((Candlestick[])c);
        }
        if (s.bullishSeparatingLines) {
            this.bullishSeparatingLines = CandlestickPatterns.bullishSeparatingLines((Candlestick[])c);
        }
        if (s.bullishTriStar) {
            this.bullishTriStar = CandlestickPatterns.bullishTriStar((Candlestick[])c);
        }
        if (s.bullishThreeStarsInTheSouth) {
            this.bullishThreeStarsInTheSouth = CandlestickPatterns.bullishThreeStarsInTheSouth((Candlestick[])c);
        }
        if (s.bullishUniqueThreeRiverBottom) {
            this.bullishUniqueThreeRiverBottom = CandlestickPatterns.bullishUniqueThreeRiverBottom((Candlestick[])c);
        }
        if (s.bullishStickSandwich) {
            this.bullishStickSandwich = CandlestickPatterns.bullishStickSandwich((Candlestick[])c);
        }
        if (s.bullishAbandonedBaby) {
            this.bullishAbandonedBaby = CandlestickPatterns.bullishAbandonedBaby((Candlestick[])c);
        }
        if (s.bullishMorningDojiStar) {
            this.bullishMorningDojiStar = CandlestickPatterns.bullishMorningDojiStar((Candlestick[])c);
        }
        if (s.bullishMorningStar) {
            this.bullishMorningStar = CandlestickPatterns.bullishMorningStar((Candlestick[])c);
        }
        if (s.bullishThreeOutsideUp) {
            this.bullishThreeOutsideUp = CandlestickPatterns.bullishThreeOutsideUp((Candlestick[])c);
        }
        if (s.bullishThreeInsideUp) {
            this.bullishThreeInsideUp = CandlestickPatterns.bullishThreeInsideUp((Candlestick[])c);
        }
        if (s.bullishThreeWhiteSoldiers) {
            this.bullishThreeWhiteSoldiers = CandlestickPatterns.bullishThreeWhiteSoldiers((Candlestick[])c);
        }
        if (s.bullishUpsideTasukiGap) {
            this.bullishUpsideTasukiGap = CandlestickPatterns.bullishUpsideTasukiGap((Candlestick[])c);
        }
        if (s.bullishUpsideGapThreeMethods) {
            this.bullishUpsideGapThreeMethods = CandlestickPatterns.bullishUpsideGapThreeMethods((Candlestick[])c);
        }
        if (s.bullishSideBySideWhiteLines) {
            this.bullishSideBySideWhiteLines = CandlestickPatterns.bullishSideBySideWhiteLines((Candlestick[])c);
        }
        if (s.bullishConcealingBabySwallow) {
            this.bullishConcealingBabySwallow = CandlestickPatterns.bullishConcealingBabySwallow((Candlestick[])c);
        }
        if (s.bullishThreeLineStrike) {
            this.bullishThreeLineStrike = CandlestickPatterns.bullishThreeLineStrike((Candlestick[])c);
        }
        if (s.bullishThreeGaps) {
            this.bullishThreeGaps = CandlestickPatterns.bullishThreeGaps((Candlestick[])c);
        }
        if (s.bullishBreakaway) {
            this.bullishBreakaway = CandlestickPatterns.bullishBreakaway((Candlestick[])c);
        }
        if (s.bullishLadderBottom) {
            this.bullishLadderBottom = CandlestickPatterns.bullishLadderBottom((Candlestick[])c);
        }
        if (s.bullishRisingThreeMethods) {
            this.bullishRisingThreeMethods = CandlestickPatterns.bullishRisingThreeMethods((Candlestick[])c);
        }
        if (s.bullishMatHold) {
            this.bullishMatHold = CandlestickPatterns.bullishMatHold((Candlestick[])c);
        }
        if (s.bearishLongBlackDay) {
            this.bearishLongBlackDay = CandlestickPatterns.bearishLongBlackDay((Candlestick[])c);
        }
        if (s.bearishBeltHold) {
            this.bearishBeltHold = CandlestickPatterns.bearishBeltHold((Candlestick[])c);
        }
        if (s.bearishHangingMan) {
            this.bearishHangingMan = CandlestickPatterns.bearishHangingMan((Candlestick[])c);
        }
        if (s.bearishDragonflyDoji) {
            this.bearishDragonflyDoji = CandlestickPatterns.bearishDragonflyDoji((Candlestick[])c);
        }
        if (s.bearishLongLeggedDoji) {
            this.bearishLongLeggedDoji = CandlestickPatterns.bearishLongLeggedDoji((Candlestick[])c);
        }
        if (s.bearishShootingStar) {
            this.bearishShootingStar = CandlestickPatterns.bearishShootingStar((Candlestick[])c);
        }
        if (s.bearishHarami) {
            this.bearishHarami = CandlestickPatterns.bearishHarami((Candlestick[])c);
        }
        if (s.bearishHaramiCross) {
            this.bearishHaramiCross = CandlestickPatterns.bearishHaramiCross((Candlestick[])c);
        }
        if (s.bearishEngulfing) {
            this.bearishEngulfing = CandlestickPatterns.bearishEngulfing((Candlestick[])c);
        }
        if (s.bearishGravestoneDoji) {
            this.bearishGravestoneDoji = CandlestickPatterns.bearishGravestoneDoji((Candlestick[])c);
        }
        if (s.bearishMeetingLines) {
            this.bearishMeetingLines = CandlestickPatterns.bearishMeetingLines((Candlestick[])c);
        }
        if (s.bearishDojiStar) {
            this.bearishDojiStar = CandlestickPatterns.bearishDojiStar((Candlestick[])c);
        }
        if (s.bearishDescendingHawk) {
            this.bearishDescendingHawk = CandlestickPatterns.bearishDescendingHawk((Candlestick[])c);
        }
        if (s.bearishMatchingHigh) {
            this.bearishMatchingHigh = CandlestickPatterns.bearishMatchingHigh((Candlestick[])c);
        }
        if (s.bearishTweezerTop) {
            this.bearishTweezerTop = CandlestickPatterns.bearishTweezerTop((Candlestick[])c);
        }
        if (s.bearishKicking) {
            this.bearishKicking = CandlestickPatterns.bearishKicking((Candlestick[])c);
        }
        if (s.bearishDarkCloudCover) {
            this.bearishDarkCloudCover = CandlestickPatterns.bearishDarkCloudCover((Candlestick[])c);
        }
        if (s.bearishSeparatingLines) {
            this.bearishSeparatingLines = CandlestickPatterns.bearishSeparatingLines((Candlestick[])c);
        }
        if (s.bearishThrusting) {
            this.bearishThrusting = CandlestickPatterns.bearishThrusting((Candlestick[])c);
        }
        if (s.bearishOnNeck) {
            this.bearishOnNeck = CandlestickPatterns.bearishOnNeck((Candlestick[])c);
        }
        if (s.bearishInNeck) {
            this.bearishInNeck = CandlestickPatterns.bearishInNeck((Candlestick[])c);
        }
        if (s.bearishTriStar) {
            this.bearishTriStar = CandlestickPatterns.bearishTriStar((Candlestick[])c);
        }
        if (s.bearishTwoCrows) {
            this.bearishTwoCrows = CandlestickPatterns.bearishTwoCrows((Candlestick[])c);
        }
        if (s.bearishAdvanceBlock) {
            this.bearishAdvanceBlock = CandlestickPatterns.bearishAdvanceBlock((Candlestick[])c);
        }
        if (s.bearishDeliberation) {
            this.bearishDeliberation = CandlestickPatterns.bearishDeliberation((Candlestick[])c);
        }
        if (s.bearishAbandonedBaby) {
            this.bearishAbandonedBaby = CandlestickPatterns.bearishAbandonedBaby((Candlestick[])c);
        }
        if (s.bearishEveningDojiStar) {
            this.bearishEveningDojiStar = CandlestickPatterns.bearishEveningDojiStar((Candlestick[])c);
        }
        if (s.bearishEveningStar) {
            this.bearishEveningStar = CandlestickPatterns.bearishEveningStar((Candlestick[])c);
        }
        if (s.bearishThreeOutsideDown) {
            this.bearishThreeOutsideDown = CandlestickPatterns.bearishThreeOutsideDown((Candlestick[])c);
        }
        if (s.bearishThreeInsideDown) {
            this.bearishThreeInsideDown = CandlestickPatterns.bearishThreeInsideDown((Candlestick[])c);
        }
        if (s.bearishUpsideGapTwoCrows) {
            this.bearishUpsideGapTwoCrows = CandlestickPatterns.bearishUpsideGapTwoCrows((Candlestick[])c);
        }
        if (s.bearishThreeBlackCrows) {
            this.bearishThreeBlackCrows = CandlestickPatterns.bearishThreeBlackCrows((Candlestick[])c);
        }
        if (s.bearishIdenticalThreeCrows) {
            this.bearishIdenticalThreeCrows = CandlestickPatterns.bearishIdenticalThreeCrows((Candlestick[])c);
        }
        if (s.bearishDownsideTasukiGap) {
            this.bearishDownsideTasukiGap = CandlestickPatterns.bearishDownsideTasukiGap((Candlestick[])c);
        }
        if (s.bearishDownsideGapThreeMethods) {
            this.bearishDownsideGapThreeMethods = CandlestickPatterns.bearishDownsideGapThreeMethods((Candlestick[])c);
        }
        if (s.bearishSideBySideWhiteLines) {
            this.bearishSideBySideWhiteLines = CandlestickPatterns.bearishSideBySideWhiteLines((Candlestick[])c);
        }
        if (s.bearishThreeLineStrike) {
            this.bearishThreeLineStrike = CandlestickPatterns.bearishThreeLineStrike((Candlestick[])c);
        }
        if (s.bearishThreeGaps) {
            this.bearishThreeGaps = CandlestickPatterns.bearishThreeGaps((Candlestick[])c);
        }
        if (s.bearishBreakaway) {
            this.bearishBreakaway = CandlestickPatterns.bearishBreakaway((Candlestick[])c);
        }
        if (s.bearishFallingThreeMethods) {
            this.bearishFallingThreeMethods = CandlestickPatterns.bearishFallingThreeMethods((Candlestick[])c);
        }
        if (s.chartType == PriceChartType.HEIKIN) {
            Map map7 = TechnicalAnalysis.heikin((Number[])this.techOpen, (Number[])this.techHigh, (Number[])this.techLow, (Number[])this.techClose);
            this.open = (Number[])map7.get(FourPrice.OPEN);
            this.close = (Number[])map7.get(FourPrice.CLOSE);
        }
    }
}

