/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.canvas;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.axis.NumberAxis;
import jp.sf.orangesignal.chart.axis.Orientation;
import jp.sf.orangesignal.chart.data.AntiWatchChartDataset;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.ChartScreenEvent;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.UpDownColorType;
import jp.sf.orangesignal.chart.ui.canvas.AbstractChartCanvas;
import jp.sf.orangesignal.chart.ui.screen.ChartScreen;
import jp.sf.orangesignal.chart.util.DrawUtils;
import jp.sf.orangesignal.chart.util.StringManager;

public class AntiWatchCanvas
extends AbstractChartCanvas {
    private static final long serialVersionUID = -4579368515123910594L;
    private final NumberAxis priceAxis = new NumberAxis();
    private final NumberAxis volumeAxis = new NumberAxis();
    private Rectangle2D chartArea = null;
    private Point mousePosition = null;
    private final ChartScreen parent;
    private AntiWatchChartDataset dataset = null;
    private int start;
    private int period;
    private ChartSettings settings;
    private static final int MARGIN = 6;
    private Image screenCache = null;
    private static final Composite ALPHA_COMPOSITE_25 = AlphaComposite.getInstance(3, 0.25f);
    private static final Composite ALPHA_COMPOSITE_20 = AlphaComposite.getInstance(3, 0.2f);
    private static final String FORMAT_DATE = StringManager.getString("format.date", new Object[0]);

    public AntiWatchCanvas(Icons icons, ChartScreen parent) {
        this.parent = parent;
        this.priceAxis.setRangeType(NumberAxis.RangeType.POSITIVE);
        this.priceAxis.setLowerPadding(0.05);
        this.priceAxis.setUpperPadding(0.05);
        this.volumeAxis.setOrientation(Orientation.HORIZONTAL);
        this.volumeAxis.setRangeType(NumberAxis.RangeType.POSITIVE);
        this.volumeAxis.setLowerPadding(0.05);
        this.volumeAxis.setUpperPadding(0.05);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                AntiWatchCanvas.this.processPosition(null, false);
                AntiWatchCanvas.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                AntiWatchCanvas.this.processPosition(new Point(e.getX(), e.getY()), false);
                AntiWatchCanvas.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AntiWatchCanvas.this.processLayout();
            }
        });
    }

    private void processPosition(Point point, boolean send) {
        this.mousePosition = this.chartArea != null && point != null && this.chartArea.contains(point) ? point : null;
        if (send) {
            this.parent.sendPositionChanged(new ChartScreenEvent(this, this.mousePosition, this.start, this.period, -1));
        }
    }

    @Override
    public void switchDataset(ChartEvent e) {
        this.dataset = (AntiWatchChartDataset)e.getDataset();
        if (!e.isIgnoreStart()) {
            this.start = e.getStart();
        }
        this.period = e.getPeriod();
        this.settings = e.getSettings();
        if (this.settings.antiwatch.fixed) {
            this.priceAxis.setFixedLower(new Double(0.0));
            this.volumeAxis.setFixedLower(new Double(0.0));
        } else {
            this.priceAxis.setFixedLower(null);
            this.volumeAxis.setFixedLower(null);
        }
        if (this.dataset != null) {
            this.priceAxis.prepare(new Number[][]{this.dataset.ma});
            this.volumeAxis.prepare(new Number[][]{this.dataset.vma});
        }
        this.adjustTicks();
        this.processLayout();
        this.processPosition(null, true);
        this.update();
    }

    private void adjustTicks() {
        if (this.dataset != null) {
            this.priceAxis.autoAdjustRange(this.start, this.period);
            this.volumeAxis.autoAdjustRange(this.start, this.period);
        }
        this.priceAxis.refreshTicks();
        this.volumeAxis.refreshTicks();
    }

    @Override
    public void setStart(int start) {
        this.start = start;
        this.update();
    }

    private void update() {
        this.adjustTicks();
        this.processPosition(null, true);
        this.screenCache = null;
        this.repaint();
    }

    private void processLayout() {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        int axisWidth = this.priceAxis.getSpace(g2);
        int axisHeight = this.volumeAxis.getSpace(g2);
        int x = 6 + axisWidth;
        int w = this.getWidth() - x - 6;
        int h = this.getHeight() - axisHeight;
        FontMetrics fm = g2.getFontMetrics(NumberAxis.FONT);
        double plotMarginHeight = (double)fm.getAscent() * 0.5 + (double)fm.getDescent();
        this.chartArea = new Rectangle2D.Double(x, plotMarginHeight, w, (double)h - plotMarginHeight);
        this.priceAxis.refreshTicks(g2, this.chartArea);
        this.volumeAxis.refreshTicks(g2, this.chartArea);
        this.screenCache = null;
    }

    @Override
    public void draw(Graphics2D g2) {
        if (this.screenCache == null) {
            this.screenCache = this.createImage();
        }
        g2.drawImage(this.screenCache, 0, 0, this);
        if (this.settings.trace) {
            this.drawAxisTrace(g2);
        }
    }

    private Image createImage() {
        Image image = this.createImage(this.getWidth(), this.getHeight());
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        this.setRenderingHints(g2);
        this.priceAxis.draw(g2, this.chartArea);
        this.volumeAxis.draw(g2, this.chartArea);
        if (this.dataset != null) {
            this.drawChart(g2);
        }
        g2.dispose();
        return image;
    }

    private void drawAxisTrace(Graphics2D g2) {
        if (this.mousePosition != null) {
            this.priceAxis.drawAxisTrace(g2, this.chartArea, this.mousePosition.y, 2);
            this.volumeAxis.drawAxisTrace(g2, this.chartArea, this.mousePosition.x, 2);
        }
    }

    private void drawChart(Graphics2D g2) {
        Shape saved = g2.getClip();
        g2.setClip(this.chartArea);
        if (this.settings.antiwatch.signalMarker) {
            this.drawOctagon(g2);
        }
        this.drawLine(g2, this.dataset.ma, this.dataset.vma, Color.RED);
        DrawUtils.drawDescription(g2, this.chartArea, StringManager.getString("screen.antiwatch", new Object[0]));
        g2.setClip(saved);
    }

    private void drawOctagon(Graphics2D g2) {
        double x = this.chartArea.getCenterX();
        double y = this.chartArea.getCenterY();
        double w = this.chartArea.getWidth() * 0.5 / Math.tan(Math.toRadians(67.5));
        double h = this.chartArea.getWidth() * 0.5 * Math.tan(Math.toRadians(22.5));
        h = h / this.chartArea.getWidth() * this.chartArea.getHeight();
        Composite originalComposite = g2.getComposite();
        UpDownColorType colors = this.settings.updownLineColors;
        GradientPaint buyPaint = new GradientPaint(0.0f, (float)this.chartArea.getMinY(), colors.getDownColor1(), 0.0f, (float)this.chartArea.getMaxY(), colors.getDownColor2());
        GradientPaint sell = new GradientPaint(0.0f, (float)this.chartArea.getMinY(), colors.getUpColor2(), 0.0f, (float)this.chartArea.getMaxY(), colors.getUpColor1());
        GeneralPath path1 = new GeneralPath();
        path1.moveTo((float)x, (float)y);
        path1.lineTo((float)(x + w), (float)this.chartArea.getMaxY());
        path1.lineTo((float)(x - w), (float)this.chartArea.getMaxY());
        path1.closePath();
        g2.setPaint(buyPaint);
        g2.setComposite(ALPHA_COMPOSITE_25);
        g2.fill(path1);
        GeneralPath path2 = new GeneralPath();
        path2.moveTo((float)x, (float)y);
        path2.lineTo((float)this.chartArea.getMaxX(), (float)(y + h));
        path2.lineTo((float)this.chartArea.getMaxX(), (float)this.chartArea.getMaxY());
        path2.lineTo((float)(x + w), (float)this.chartArea.getMaxY());
        path2.closePath();
        g2.setPaint(buyPaint);
        g2.setComposite(ALPHA_COMPOSITE_25);
        g2.fill(path2);
        GeneralPath path3 = new GeneralPath();
        path3.moveTo((float)x, (float)y);
        path3.lineTo((float)this.chartArea.getMaxX(), (float)(y - h));
        path3.lineTo((float)this.chartArea.getMaxX(), (float)(y + h));
        path3.closePath();
        g2.setPaint(buyPaint);
        g2.setComposite(ALPHA_COMPOSITE_25);
        g2.fill(path3);
        GeneralPath path4 = new GeneralPath();
        path4.moveTo((float)x, (float)y);
        path4.lineTo((float)(x + w), (float)this.chartArea.getMinY());
        path4.lineTo((float)this.chartArea.getMaxX(), (float)this.chartArea.getMinY());
        path4.lineTo((float)this.chartArea.getMaxX(), (float)(y - h));
        path4.closePath();
        g2.setPaint(buyPaint);
        g2.setComposite(ALPHA_COMPOSITE_20);
        g2.fill(path4);
        GeneralPath path5 = new GeneralPath();
        path5.moveTo((float)x, (float)y);
        path5.lineTo((float)(x - w), (float)this.chartArea.getMinY());
        path5.lineTo((float)(x + w), (float)this.chartArea.getMinY());
        path5.closePath();
        g2.setPaint(sell);
        g2.setComposite(ALPHA_COMPOSITE_25);
        g2.fill(path5);
        GeneralPath path6 = new GeneralPath();
        path6.moveTo((float)x, (float)y);
        path6.lineTo((float)this.chartArea.getMinX(), (float)(y - h));
        path6.lineTo((float)this.chartArea.getMinX(), (float)this.chartArea.getMinY());
        path6.lineTo((float)(x - w), (float)this.chartArea.getMinY());
        path6.closePath();
        g2.setPaint(sell);
        g2.setComposite(ALPHA_COMPOSITE_25);
        g2.fill(path6);
        GeneralPath path7 = new GeneralPath();
        path7.moveTo((float)x, (float)y);
        path7.lineTo((float)this.chartArea.getMinX(), (float)(y + h));
        path7.lineTo((float)this.chartArea.getMinX(), (float)(y - h));
        path7.closePath();
        g2.setPaint(sell);
        g2.setComposite(ALPHA_COMPOSITE_25);
        g2.fill(path7);
        GeneralPath path8 = new GeneralPath();
        path8.moveTo((float)x, (float)y);
        path8.lineTo((float)(x - w), (float)this.chartArea.getMaxY());
        path8.lineTo((float)this.chartArea.getMinX(), (float)this.chartArea.getMaxY());
        path8.lineTo((float)this.chartArea.getMinX(), (float)(y + h));
        path8.closePath();
        g2.setPaint(sell);
        g2.setComposite(ALPHA_COMPOSITE_20);
        g2.fill(path8);
        g2.setComposite(originalComposite);
        g2.setColor(Color.WHITE);
        g2.draw(new Line2D.Double(x + w, this.chartArea.getMinY(), x - w, this.chartArea.getMaxY()));
        g2.draw(new Line2D.Double(this.chartArea.getMinX(), y + h, this.chartArea.getMaxX(), y - h));
        g2.draw(new Line2D.Double(this.chartArea.getMinX(), y - h, this.chartArea.getMaxX(), y + h));
        g2.draw(new Line2D.Double(x - w, this.chartArea.getMinY(), x + w, this.chartArea.getMaxY()));
    }

    private void drawLine(Graphics2D g2, Number[] price, Number[] volume, Color color) {
        FontMetrics fm = g2.getFontMetrics();
        for (int i = this.start + 1; i < this.start + this.period; ++i) {
            String text;
            if (i < 0 || i >= this.dataset.getCount() || i - 1 < 0 || i - 1 >= this.dataset.getCount() || price[i] == null || volume[i] == null || price[i - 1] == null || volume[i - 1] == null) continue;
            double x1 = this.volumeAxis.valueToJava2D(volume[i - 1].doubleValue(), this.chartArea);
            double y1 = this.priceAxis.valueToJava2D(price[i - 1].doubleValue(), this.chartArea);
            double x2 = this.volumeAxis.valueToJava2D(volume[i].doubleValue(), this.chartArea);
            double y2 = this.priceAxis.valueToJava2D(price[i].doubleValue(), this.chartArea);
            g2.setColor(color);
            g2.draw(new Line2D.Double(x1, y1, x2, y2));
            if (i == this.start + 1) {
                text = String.format(FORMAT_DATE, this.dataset.date[i - 1]);
                DrawUtils.drawText(g2, text, (float)(x1 - (double)fm.stringWidth(text) * 0.5), (float)(y1 - 2.0));
            }
            if (i + 1 != this.start + this.period) continue;
            text = String.format(FORMAT_DATE, this.dataset.date[i]);
            DrawUtils.drawText(g2, text, (float)(x2 - (double)fm.stringWidth(text) * 0.5), (float)(y2 - 2.0));
        }
    }
}

