/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.canvas;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import jp.sf.orangesignal.chart.ChartColor;
import jp.sf.orangesignal.chart.axis.DateAxis;
import jp.sf.orangesignal.chart.axis.DateTickUnit;
import jp.sf.orangesignal.chart.axis.NumberAxis;
import jp.sf.orangesignal.chart.data.BasicChartDataset;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.GlobalChartEvent;
import jp.sf.orangesignal.chart.event.GlobalChartListener;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.canvas.AbstractChartCanvas;

public class GlobalChartCanvas
extends AbstractChartCanvas {
    private static final long serialVersionUID = 4683298117709980110L;
    protected final List<GlobalChartListener> listeners = new ArrayList<GlobalChartListener>(1);
    private final NumberAxis priceAxis = new NumberAxis();
    private final DateAxis dateAxis = new DateAxis();
    private Rectangle2D chartArea;
    private BasicChartDataset dataset;
    public int start;
    public int period;
    private static final int MARGIN = 16;
    private double periodWidth;
    private Image screenCache = null;
    private static final Composite COMPOSITE = AlphaComposite.getInstance(3, 0.5f);

    public void addGlobalChartListener(GlobalChartListener listener) {
        this.listeners.add(listener);
    }

    public GlobalChartCanvas(Icons icons) {
        this.priceAxis.setRangeType(NumberAxis.RangeType.POSITIVE);
        this.priceAxis.setLowerPadding(0.05);
        this.priceAxis.setUpperPadding(0.05);
        this.dateAxis.setTickUnit(DateTickUnit.ONE_YEAR);
        this.dateAxis.setInside(true);
        this.setPreferredSize(new Dimension(0, 50));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GlobalChartCanvas.this.processScope(new Point(e.getX(), e.getY()));
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                GlobalChartCanvas.this.processScope(new Point(e.getX(), e.getY()));
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GlobalChartCanvas.this.processLayout();
            }
        });
    }

    private void processScope(Point point) {
        if (this.dataset != null && this.chartArea.contains(point)) {
            int n = (int)Math.floor(((double)point.x - this.chartArea.getMinX()) / this.periodWidth) - this.period / 2;
            if (n < 0) {
                n = 0;
            } else if (n > this.dataset.getCount() - this.period) {
                n = this.dataset.getCount() - this.period;
            }
            if (this.start != n) {
                this.start = n;
                this.repaint();
                GlobalChartEvent event = new GlobalChartEvent(this, this.start);
                for (GlobalChartListener listener : this.listeners) {
                    listener.scopeChanged(event);
                }
            }
        }
    }

    private void processLayout() {
        this.chartArea = new Rectangle2D.Double(16.0, 0.0, this.getWidth() - 32, this.getHeight());
        if (this.dataset != null) {
            this.periodWidth = (this.chartArea.getWidth() - 1.0) / (double)this.dataset.getCount();
        }
        this.screenCache = null;
    }

    @Override
    public void switchDataset(ChartEvent e) {
        this.dataset = (BasicChartDataset)e.getDataset();
        if (!e.isIgnoreStart()) {
            this.start = e.getStart();
        }
        this.period = e.getPeriod();
        if (e.getSettings().timeSeries.fixed) {
            this.priceAxis.setFixedLower(new Double(0.0));
        } else {
            this.priceAxis.setFixedLower(null);
        }
        if (this.dataset != null) {
            this.dateAxis.prepare(e.getType(), this.dataset.getCount());
            this.priceAxis.prepare(new Number[][]{this.dataset.high, this.dataset.low});
            this.priceAxis.autoAdjustRange(0, this.dataset.getCount());
        }
        this.priceAxis.refreshTicks();
        this.processLayout();
    }

    @Override
    public void setStart(int start) {
        this.start = start;
        this.repaint();
    }

    @Override
    public void draw(Graphics2D g2) {
        if (this.screenCache == null) {
            this.screenCache = this.createImage();
        }
        g2.drawImage(this.screenCache, 0, 0, this);
        if (this.dataset != null) {
            this.drawScope(g2);
            this.dateAxis.draw(g2, this.chartArea, this.periodWidth, this.dataset.date, 0, this.dataset.getCount());
        }
    }

    private Image createImage() {
        Image image = this.createImage(this.getWidth(), this.getHeight());
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        this.setRenderingHints(g2);
        if (this.dataset != null) {
            this.drawChart(g2);
        }
        g2.dispose();
        return image;
    }

    private void drawScope(Graphics2D g2) {
        Shape saved = g2.getClip();
        double x1 = this.chartArea.getMinX() + (double)this.start * this.periodWidth;
        double x2 = this.chartArea.getMinX() + (double)(this.start + this.period) * this.periodWidth;
        int height = this.getHeight();
        Rectangle2D.Double rect = new Rectangle2D.Double(x1, 0.0, x2 - x1 + 1.0, height);
        g2.setClip(rect);
        g2.setColor(Color.WHITE);
        g2.fill(rect);
        this.drawPath(g2, this.chartArea, this.priceAxis, this.dataset.close, this.start, this.period, ChartColor.SKY_BLUE);
        this.drawLine(g2, this.chartArea, this.priceAxis, this.dataset.close, this.start, this.period, ChartColor.SKY_BLUE);
        g2.draw(new Line2D.Double(x1, 0.0, x1, height));
        g2.draw(new Line2D.Double(x2, 0.0, x2, height));
        g2.setClip(saved);
    }

    private void drawChart(Graphics2D g2) {
        Shape saved = g2.getClip();
        g2.setClip(this.chartArea);
        int count = this.dataset.getCount();
        this.drawPath(g2, this.chartArea, this.priceAxis, this.dataset.close, 0, count, Color.GRAY);
        this.drawLine(g2, this.chartArea, this.priceAxis, this.dataset.close, 0, count, Color.LIGHT_GRAY);
        g2.setClip(saved);
    }

    private void drawLine(Graphics2D g2, Rectangle2D area, NumberAxis axis, Number[] data, int start, int period, Color color) {
        g2.setColor(color);
        double width = (this.chartArea.getWidth() - 1.0) / (double)(this.dataset.getCount() - 1);
        for (int i = start - 1; i < start + period + 1; ++i) {
            if (i < 0 || i >= this.dataset.getCount() - 1 || data[i] == null || data[i + 1] == null) continue;
            double x1 = area.getMinX() + (double)i * width;
            double x2 = area.getMinX() + (double)(i + 1) * width;
            double y1 = axis.valueToJava2D(data[i].doubleValue(), area);
            double y2 = axis.valueToJava2D(data[i + 1].doubleValue(), area);
            g2.draw(new Line2D.Double(x1, y1, x2, y2));
        }
    }

    private void drawPath(Graphics2D g2, Rectangle2D area, NumberAxis axis, Number[] data, int start, int period, Color color) {
        Composite originalComposite = g2.getComposite();
        g2.setComposite(COMPOSITE);
        double width = (this.chartArea.getWidth() - 1.0) / (double)(this.dataset.getCount() - 1);
        for (int i = start - 1; i < start + period + 1; ++i) {
            if (i < 0 || i >= this.dataset.getCount() - 1 || data[i] == null || data[i + 1] == null) continue;
            double x1 = area.getMinX() + (double)i * width;
            double x2 = area.getMinX() + (double)(i + 1) * width;
            double y1 = axis.valueToJava2D(data[i].doubleValue(), area);
            double y2 = axis.valueToJava2D(data[i + 1].doubleValue(), area);
            GeneralPath path = new GeneralPath();
            path.moveTo((float)x1, (float)y1);
            path.lineTo((float)x2, (float)y2);
            path.lineTo((float)x2, (float)area.getMaxY());
            path.lineTo((float)x1, (float)area.getMaxY());
            path.closePath();
            g2.setPaint(new GradientPaint((float)area.getMinX(), (float)area.getMinY(), color, (float)area.getMinX(), (float)area.getMaxY(), Color.WHITE));
            g2.fill(path);
        }
        g2.setComposite(originalComposite);
    }
}

