/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jp.sf.orangesignal.chart.ChartColor;
import jp.sf.orangesignal.chart.FontConstants;

public abstract class DrawUtils {
    private static final Composite COMPOSITE = AlphaComposite.getInstance(3, 0.5f);

    public static void drawText(Graphics2D g2, String text, float x, float y) {
        DrawUtils.drawText(g2, text, x, y, Color.BLACK, Color.LIGHT_GRAY);
    }

    public static void drawText(Graphics2D g2, String text, float x, float y, Color color) {
        DrawUtils.drawText(g2, text, x, y, color, Color.LIGHT_GRAY);
    }

    private static void drawText(Graphics2D g2, String text, float x, float y, Color color, Color shadow) {
        Composite originalComposite = g2.getComposite();
        g2.setComposite(COMPOSITE);
        g2.setColor(shadow);
        g2.drawString(text, x + 1.0f, y);
        g2.drawString(text, x, y + 1.0f);
        g2.drawString(text, x + 1.0f, y + 1.0f);
        g2.setComposite(originalComposite);
        g2.setColor(color);
        g2.drawString(text, x, y);
    }

    public static void drawDescription(Graphics2D g2, Rectangle2D area, String text) {
        g2.setFont(FontConstants.FONT_GUI);
        float x = (float)area.getMinX();
        float y = (float)area.getMinY() + (float)g2.getFontMetrics().getAscent();
        DrawUtils.drawText(g2, text, x, y, ChartColor.GRAY);
    }
}

