/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.candle.generator;

import java.util.Date;
import java.util.List;
import jp.sf.orangesignal.ta.candle.TrendType;
import jp.sf.orangesignal.ta.candle.generator.DefaultCandlestick;
import jp.sf.orangesignal.ta.candle.generator.TrendProcessor;
import jp.sf.orangesignal.ta.candle.generator.TrendProcessorException;
import jp.sf.orangesignal.ta.result.Step;

public abstract class StepTrendProcessor
implements TrendProcessor {
    private final List<Step> data;

    public StepTrendProcessor(List<Step> data) {
        this.data = data;
    }

    @Override
    public final void execute(DefaultCandlestick[] c) throws TrendProcessorException {
        int len = c.length;
        int start = 0;
        block0: for (Step step : this.data) {
            TrendType trend = this.getTrend(step);
            for (int i = start; i < len; ++i) {
                if (c[i] == null) continue;
                Date date = c[i].getDate();
                if (date == null) {
                    throw new TrendProcessorException();
                }
                if (step.openDate.compareTo(date) <= 0 && step.closeDate.compareTo(date) >= 0) {
                    c[i].trend = trend;
                    continue;
                }
                start = i;
                continue block0;
            }
        }
    }

    protected abstract TrendType getTrend(Step var1);
}

