/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.dataset.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.orangesignal.ta.dataset.IntervalType;
import jp.sf.orangesignal.ta.dataset.PriceData;
import jp.sf.orangesignal.ta.dataset.TimeSeriesDataset;
import jp.sf.orangesignal.ta.dataset.loader.DatasetLoadEvent;
import jp.sf.orangesignal.ta.dataset.loader.DatasetLoadListener;
import jp.sf.orangesignal.ta.dataset.loader.DatasetLoader;
import jp.sf.orangesignal.ta.dataset.loader.LoadException;
import jp.sf.orangesignal.ta.dataset.loader.PriceDataLoader;

public class FileDatasetLoader
implements DatasetLoader {
    private PriceDataLoader loader = new PriceDataLoader();
    private Map<String, String> symbolMap = new HashMap<String, String>();
    private IntervalType interval = IntervalType.DAILY;
    private List<DatasetLoadListener> listeners = new ArrayList<DatasetLoadListener>(1);
    private String symbol;

    public PriceDataLoader getLoader() {
        return this.loader;
    }

    public void setLoader(PriceDataLoader loader) {
        this.loader = loader;
    }

    public Map<String, String> getSymbolMap() {
        return this.symbolMap;
    }

    public void setSymbolMap(Map<String, String> symbolMap) {
        this.symbolMap = symbolMap;
    }

    public IntervalType getInterval() {
        return this.interval;
    }

    public void setInterval(IntervalType interval) {
        this.interval = interval;
    }

    public void addDatasetLoadListener(DatasetLoadListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public TimeSeriesDataset load() throws LoadException {
        String filename = this.symbolMap.get(this.symbol);
        if (filename == null || filename.isEmpty()) {
            throw new LoadException("filename is empty.");
        }
        try {
            List<PriceData> prices = this.loader.load(filename);
            TimeSeriesDataset dataset = new TimeSeriesDataset(this.interval, prices.toArray(new PriceData[0]));
            dataset.setSymbol(this.symbol);
            DatasetLoadEvent event = new DatasetLoadEvent(this, dataset);
            for (DatasetLoadListener listener : this.listeners) {
                listener.datasetLoaded(event);
            }
            return dataset;
        }
        catch (Exception e) {
            throw new LoadException(e.getMessage(), e);
        }
    }
}

