/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart;

import java.awt.Color;

import jp.sf.orangesignal.chart.ui.BandType;
import jp.sf.orangesignal.chart.ui.PriceChartType;
import jp.sf.orangesignal.chart.ui.MAType;
import jp.sf.orangesignal.chart.ui.PeriodType;
import jp.sf.orangesignal.chart.ui.PriceScaleType;
import jp.sf.orangesignal.chart.ui.ChartScreenType;
import jp.sf.orangesignal.chart.ui.UpDownColorType;
import jp.sf.orangesignal.chart.ui.VolumeType;

/**
 * 設定情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public class ChartSettings {

	// ---------------------------------------- 全体設定

	/**
	 * 4本値の少数点以下表示桁数を保持します。
	 */
	public int precision = 0;

	/**
	 * 株式分割修正(権利落ち修正)をするかどうかを保持します。
	 */
	public boolean split = true;

	/**
	 * トレース線を表示するかどうかを保持します。
	 */
	public boolean trace = true;

	/**
	 * 陰陽棒領域の色情報を保持します。
	 */
	public UpDownColorType updownBarColors = UpDownColorType.RED_BLUE;

	/**
	 * 陰陽線の色情報を保持します。
	 */
	public UpDownColorType updownLineColors = UpDownColorType.RED_BLUE;

	/**
	 * 上級者用オプションを表示するかどうかを保持します。
	 */
	public boolean advancedOptions = false;

	// ---------------------------------------- 価格

	/**
	 * 価格チャートの設定情報を提供します。
	 */
	public static final class TimeSeriesSettings {

		/**
		 * 株式分割マーカーを表示するかどうかを保持します。
		 */
		public boolean splitMarker = true;

		/**
		 * シグナルマーカーを表示するかどうかを保持します。
		 */
		public boolean signalMarker = true;

		public Color soldColor = Color.BLUE;
		public Color boughtColor = Color.RED;

		public Color oscillatorColor1 = Color.RED;
		public Color oscillatorColor2 = Color.BLUE;
		public Color oscillatorColor3 = ChartColor.DARK_GREEN;

		// ---------------------------------------- 価格

		/**
		 * 範囲に0を含めるかどうかを保持します。
		 */
		public boolean fixed = false;

		/**
		 * 目盛りの種類を保持します。
		 */
		public PriceScaleType scale = PriceScaleType.NORMAL;
	
		/**
		 * 4本値チャートの種類を保持します。
		 */
		public PriceChartType chartType = PriceChartType.CANDLESTICK;

		public boolean avgprice = false;
		public boolean mp = false;

		// ---------------------------------------- ティピカル・プライス

		/**
		 * ティピカル・プライスを表示するかどうかを保持します。
		 */
		public boolean tp = false;

		// ---------------------------------------- 加重終値

		/**
		 * 加重終値を表示するかどうかを保持します。
		 */
		public boolean wc = false;

		// ---------------------------------------- ローソク足

		public boolean zigzag = false;
		public int zigzag_rate = 5;

		public boolean kagi = false;
		public int kagi_rate = 3;

		public ChartScreenType candleTrend = ChartScreenType.KAGI;

		public boolean bullishLongWhiteDay = false;
		public boolean bullishBeltHold = false;
		public boolean bullishHammer = false;
		public boolean bullishDragonflyDoji = false;
		public boolean bullishLongLeggedDoji = false;
		public boolean bullishInvertedHammer = false;
		public boolean bullishHarami = false;
		public boolean bullishHaramiCross = false;
		public boolean bullishEngulfing = false;
		public boolean bullishGravestoneDoji = false;
		public boolean bullishMeetingLines = false;
		public boolean bullishDojiStar = false;
		public boolean bullishHomingPigeon = false;
		public boolean bullishMatchingLow = false;
		public boolean bullishTweezerBottom = false;
		public boolean bullishKicking = false;
		public boolean bullishPiercingLine = false;
		public boolean bullishSeparatingLines = false;
		public boolean bullishTriStar = false;
		public boolean bullishThreeStarsInTheSouth = false;
		public boolean bullishUniqueThreeRiverBottom = false;
		public boolean bullishStickSandwich = false;
		public boolean bullishAbandonedBaby = false;
		public boolean bullishMorningDojiStar = false;
		public boolean bullishMorningStar = false;
		public boolean bullishThreeOutsideUp = false;
		public boolean bullishThreeInsideUp = false;
		public boolean bullishThreeWhiteSoldiers = false;
		public boolean bullishUpsideTasukiGap = false;
		public boolean bullishUpsideGapThreeMethods = false;
		public boolean bullishSideBySideWhiteLines = false;
		public boolean bullishConcealingBabySwallow = false;
		public boolean bullishThreeLineStrike = false;
		public boolean bullishThreeGaps = false;
		public boolean bullishBreakaway = false;
		public boolean bullishLadderBottom = false;
		public boolean bullishRisingThreeMethods = false;
		public boolean bullishMatHold = false;

		public boolean bearishLongBlackDay = false;
		public boolean bearishBeltHold = false;
		public boolean bearishHangingMan = false;
		public boolean bearishDragonflyDoji = false;
		public boolean bearishLongLeggedDoji = false;
		public boolean bearishShootingStar = false;
		public boolean bearishHarami = false;
		public boolean bearishHaramiCross = false;
		public boolean bearishEngulfing = false;
		public boolean bearishGravestoneDoji = false;
		public boolean bearishMeetingLines = false;
		public boolean bearishDojiStar = false;
		public boolean bearishDescendingHawk = false;
		public boolean bearishMatchingHigh = false;
		public boolean bearishTweezerTop = false;
		public boolean bearishKicking = false;
		public boolean bearishDarkCloudCover = false;
		public boolean bearishSeparatingLines = false;
		public boolean bearishThrusting = false;
		public boolean bearishOnNeck = false;
		public boolean bearishInNeck = false;
		public boolean bearishTriStar = false;
		public boolean bearishTwoCrows = false;
		public boolean bearishAdvanceBlock = false;
		public boolean bearishDeliberation = false;
		public boolean bearishAbandonedBaby = false;
		public boolean bearishEveningDojiStar = false;
		public boolean bearishEveningStar = false;
		public boolean bearishThreeOutsideDown = false;
		public boolean bearishThreeInsideDown = false;
		public boolean bearishUpsideGapTwoCrows = false;
		public boolean bearishThreeBlackCrows = false;
		public boolean bearishIdenticalThreeCrows = false;
		public boolean bearishDownsideTasukiGap = false;
		public boolean bearishDownsideGapThreeMethods = false;
		public boolean bearishSideBySideWhiteLines = false;
		public boolean bearishThreeLineStrike = false;
		public boolean bearishThreeGaps = false;
		public boolean bearishBreakaway = false;
		public boolean bearishFallingThreeMethods = false;

		// ---------------------------------------- 移動平均線

		/**
		 * 移動平均線を表示するかどうかを保持します。
		 */
		public boolean ma = true;

		/**
		 * 移動平均線で使用する移動平均の種類を保持します。
		 */
		public MAType maType = MAType.SMA;

		/**
		 * 移動平均1の期間を保持します。
		 */
		public int ma1Period = 25;

		/**
		 * 移動平均2の期間を保持します。
		 */
		public int ma2Period = 75;

		/**
		 * 移動平均1の色を保持します。
		 */
		public Color ma1Color = Color.RED;

		/**
		 * 移動平均2の色を保持します。
		 */
		public Color ma2Color = Color.BLUE;

		// ---------------------------------------- 線形回帰トレンド

		/**
		 * 線形回帰トレンドを表示するかどうかを保持します。
		 */
		public boolean lr = false;

		/**
		 * 線形回帰トレンド1の期間を保持します。
		 */
		public int lr1Period = 25;

		/**
		 * 線形回帰トレンド2の期間を保持します。
		 */
		public int lr2Period = 75;

		public Color lrColor = Color.RED;
		public Color lr1UpperColor = Color.BLUE;
		public Color lr1LowerColor = Color.BLUE;
		public Color lr2UpperColor = Color.BLUE;
		public Color lr2LowerColor = Color.BLUE;

		// ---------------------------------------- バンド系

		/**
		 * バンド系テクニカル指標の種類を保持します。
		 */
		public BandType bandType = BandType.NONE;

		// ---------------------------------------- ボリンジャーバンド

		/**
		 * ボリンジャーバンドの期間を保持します。
		 */
		public int bbPeriod = 25;

		public double bbRate = 1.0;

		public Color bbUpper2Color = Color.RED;
		public Color bbUpper1Color = ChartColor.RED;
		public Color bbColor = Color.BLUE;
		public Color bbLower1Color = Color.RED;
		public Color bbLower2Color = Color.RED;

		// ---------------------------------------- ドンチャンズ

		/**
		 * ドンチャンズの期間を保持します。
		 */
		public int donchianPeriod = 20;

		// ---------------------------------------- エンベロープ

		/**
		 * エンベロープで使用する移動平均の種類を保持します。
		 */
		public MAType envelopeMaType = MAType.SMA;

		/**
		 * エンベロープの期間を保持します。
		 */
		public int envelopePeriod = 25;

		/**
		 * エンベロープの値幅(%)を保持します。
		 */
		public int envelopeRate = 5;

		public Color envelopeUpper2Color = Color.BLUE;
		public Color envelopeUpper1Color = Color.BLUE;
		public Color envelopeColor = Color.RED;
		public Color envelopeLower1Color = Color.BLUE;
		public Color envelopeLower2Color = Color.BLUE;

		// ---------------------------------------- チャネルシステム

		/**
		 * チャネルシステムで使用する移動平均の種類を保持します。
		 */
		public MAType hlmaMaType = MAType.SMA;

		/**
		 * チャネルシステムの高値の期間を保持します。
		 */
		public int hmaPeriod = 10;

		/**
		 * チャネルシステムの安値の期間を保持します。
		 */
		public int lmaPeriod = 10;

		// ---------------------------------------- PIVOT

		public Color pivotHBOPColor = Color.BLUE;
		public Color pivotS2Color = Color.RED;
		public Color pivotS1Color = Color.RED;
		public Color pivotColor = Color.BLUE;
		public Color pivotB1Color = Color.RED;
		public Color pivotB2Color = Color.RED;
		public Color pivotLBOPColor = Color.BLUE;

		// ---------------------------------------- パラボリック

		/**
		 * パラボリックの加速因数を保持します。
		 */
		public double af = 0.02;

		// ---------------------------------------- ボラティリティ・システム

		public int atrPeriod = 5;
		public double atrWeight = 2.0;
		public Color viUpperColor = Color.RED;
		public Color viLowerColor = Color.BLUE;

		// ---------------------------------------- 一目均衡表

		/**
		 * 一目均衡表の基準の期間を保持します。
		 */
		public int kijunPeriod = 26;

		/**
		 * 一目均衡表の転換の期間を保持します。
		 */
		public int tenkanPeriod = 9;

		/**
		 * 一目均衡表のスパンの期間を保持します。
		 */
		public int spanPeriod = 26;

		public Color ichimokuKijunColor = ChartColor.VERY_DARK_GREEN;
		public Color ichimokuTenkanColor = Color.RED;
		public Color ichimokuSenkou1Color = Color.BLACK;
		public Color ichimokuSenkou2Color = Color.BLACK;
		public Color ichimokuChikouColor = Color.BLUE;

		// ---------------------------------------- VIDYA

		public int vidya_period = 12;
		public int vidya_cmo_period = 9;

		// ---------------------------------------- アルーン

		/**
		 * アルーンを表示するかどうかを保持します。
		 */
		public boolean aroon = false;

		/**
		 * アルーンの期間を保持します。
		 */
		public int aroonPeriod = 14;

		// ---------------------------------------- ATR

		public boolean atr = false;
		public int atr_period = 14;
		public boolean natr = false;
		public int natr_period = 14;

		// ---------------------------------------- BMP

		public boolean bop = false;

		// ------------------------------ チャイキンズ・ボラティリティ

		/**
		 * チャイキンズ・ボラティリティを表示するかどうかを保持します。
		 */
		public boolean chv = false;

		/**
		 * チャイキンズ・ボラティリティの期間1を保持します。
		 */
		public int chv_period1 = 10;

		/**
		 * チャイキンズ・ボラティリティの期間2を保持します。
		 */
		public int chv_period2 = 10;

		// ---------------------------------------- CCI

		/**
		 * CCIを表示するかどうかを保持します。
		 */
		public boolean cci = false;

		/**
		 * CCIの期間を保持します。
		 */
		public int cciPeriod = 20;

		/**
		 * CCI の売りシグナルの閾値を保持します。
		 */
		public int cciUpperSignal = 100;

		/**
		 * CCI の買いシグナルの閾値を保持します。
		 */
		public int cciLowerSignal = -100;

		// ------------------------------ チャイキンズ・マネー・フロー

		public boolean cmf = false;
		public int cmf_period = 21;

		// ---------------------------------------- CMO

		public boolean cmo = false;

		public int cmo_period = 25;
		public int cmo_upper_signal = 50;
		public int cmo_lower_signal = -50;

		// ---------------------------------------- コポック

		/**
		 * コポックを表示するかどうかを保持します。
		 */
		public boolean coppock = false;

		/**
		 * コポックの期間を保持します。
		 */
		public int coppockRocPeriod = 12;

		/**
		 * コポックで使用する移動平均の種類を保持します。
		 */
		public MAType coppockMaType = MAType.WMA;

		/**
		 * コポックの期間を保持します。
		 */
		public int coppockPeriod = 10;

		// ---------------------------------------- C-RSI

		public boolean crsi = false;
		public int crsi_period1 = 14;
		public int crsi_period2 = 6;
		public int crsi_upper_signal = 70;
		public int crsi_lower_signal = 30;

		// ---------------------------------------- DPO

		/**
		 * DPO を表示するかどうかを保持します。
		 */
		public boolean dpo = false;

		/**
		 * DPOで使用する移動平均の種類を保持します。
		 */
		public MAType dpoMaType = MAType.SMA;

		/**
		 * DPO の期間を保持します。
		 */
		public int dpoPeriod = 10;

		// ---------------------------------------- DMI

		/**
		 * DMIを表示するかどうかを保持します。
		 */
		public boolean dmi = false;

		/**
		 * DIの期間を保持します。
		 */
		public int diPeriod = 14;

		/**
		 * ADXの期間を保持します。
		 */
		public int adxPeriod = 9;

		public Color pdiColor = Color.BLUE;
		public Color mdiColor = Color.RED;
		public Color adxColor = ChartColor.DARK_GREEN;

		// ---------------------------------------- EMV

		public boolean emv = false;
		public int emv_period = 1;

		// ---------------------------------------- ヒストリカル・ボラティリティ

		/**
		 * ヒストリカル・ボラティリティを表示するかどうかを保持します。
		 */
		public boolean hv = false;

		/**
		 * ヒストリカル・ボラティリティの期間を保持します。
		 */
		public int hvPeriod = 20;

		// ---------------------------------------- 移動平均乖離率

		/**
		 * 移動平均乖離率を表示するかどうかを保持します。
		 */
		public boolean kairi = false;

		/**
		 * 移動平均乖離率で使用する移動平均の種類を保持します。
		 */
		public MAType biasMaType = MAType.SMA;

		/**
		 * 移動平均乖離率の期間を保持します。
		 */
		public int biasPeriod = 25;

		/**
		 * 移動平均乖離率の売りシグナル閾値を保持します。
		 */
		public int biasUpperSignal = 10;

		/**
		 * 移動平均乖離率の買いシグナル閾値を保持します。
		 */
		public int biasLowerSignal = -10;

		// ---------------------------------------- マス・インデックス(MI)

		/**
		 * MI を表示するかどうかを保持します。
		 */
		public boolean mi = false;

		/**
		 * MIで使用する移動平均の種類を保持します。
		 */
		public MAType miMaType = MAType.EMA;

		/**
		 * MI の移動平均期間を保持します。
		 */
		public int miMaPeriod = 9;

		/**
		 * MI の合計期間を保持します。
		 */
		public int miSumPeriod = 25;

		// ---------------------------------------- モメンタム

		/**
		 * モメンタムを表示するかどうかを保持します。
		 */
		public boolean mom = false;

		/**
		 * モメンタムの期間を保持します。
		 */
		public int mom_period = 25;

		// ---------------------------------------- MFI

		/**
		 * MFI を表示するかどうかを保持します。
		 */
		public boolean mfi = false;

		/**
		 * MFI の期間を保持します。
		 */
		public int mfiPeriod = 14;

		/**
		 * MFI の売りシグナルの閾値を保持します。
		 */
		public int mfiUpperSignal = 80;

		/**
		 * MFI の買いシグナルの閾値を保持します。
		 */
		public int mfiLowerSignal = 20;

		// ---------------------------------------- MACD

		/**
		 * MACD を表示するかどうかを保持します。
		 */
		public boolean macd = false;

		/**
		 * MACD の指数平滑移動平均1(EMA1)の期間を保持します。
		 */
		public int macdMa1Period = 25;

		/**
		 * MACD の指数平滑移動平均2(EMA2)の期間を保持します。
		 */
		public int macdMa2Period = 75;

		/**
		 * MACD シグナルで使用する移動平均の種類を保持します。
		 */
		public MAType macdSignalMaType = MAType.SMA;

		/**
		 * MACD のシグナルの期間を保持します。
		 */
		public int macdSignalPeriod = 9;

		public Color macdColor = Color.RED;
		public Color macdSignalColor = Color.BLUE;

		// ---------------------------------------- PAIN

		public boolean pain = false;

		// ---------------------------------------- PCR

		public boolean pcr = false;
		public int pcr_period = 9;
		public int pcr_upper_signal = -20;
		public int pcr_lower_signal = -80;

		// ---------------------------------------- プライス・オシレータ(APO)

		/**
		 * プライス・オシレータ(APO)を表示するかどうかを保持します。
		 */
		public boolean apo = false;

		/**
		 * プライス・オシレータ(APO)の期間1を保持します。
		 */
		public int apoMa1Period = 10;

		/**
		 * プライス・オシレータ(APO)の期間2を保持します。
		 */
		public int apoMa2Period = 30;

		// ---------------------------------------- プライス・オシレータ(PPO)

		/**
		 * プライス・オシレータ(PPO)を表示するかどうかを保持します。
		 */
		public boolean ppo = false;

		/**
		 * プライス・オシレータ(PPO)の期間1を保持します。
		 */
		public int ppoMa1Period = 10;

		/**
		 * プライス・オシレータ(PPO)の期間2を保持します。
		 */
		public int ppoMa2Period = 30;

		// ---------------------------------------- サイコロジカルライン

		/**
		 * サイコロジカルラインを表示するかどうかを保持します。
		 */
		public boolean psy = false;

		/**
		 * サイコロジカルラインの期間を保持します。
		 */
		public int psy_period = 12;

		/**
		 * サイコロジカルラインの売りシグナルの閾値を保持します。
		 */
		public int psy_upper_signal = 75;

		/**
		 * サイコロジカルラインの買いシグナルの閾値を保持します。
		 */
		public int psy_lower_signal = 25;

		// ---------------------------------------- Qstick

		public boolean qstick = false;
		public MAType qstick_matype = MAType.SMA;
		public int qstick_period = 8;

		// ---------------------------------------- RSI

		/**
		 * RSI を表示するかどうかを保持します。
		 */
		public boolean rsi = false;

		/**
		 * RSI の期間を保持します。
		 */
		public int rsiPeriod = 14;

		/**
		 * RSI の売りシグナルの閾値を保持します。
		 */
		public int rsiUpperSignal = 75;

		/**
		 * RSI の買いシグナルの閾値を保持します。
		 */
		public int rsiLowerSignal = 25;

		// ---------------------------------------- RVI

		public boolean rvi = false;
		public int rvi_period = 14;
		public int rvi_upper_signal = 70;
		public int rvi_lower_signal = 30;

		// ---------------------------------------- RCI

		/**
		 * RCI を表示するかどうかを保持します。
		 */
		public boolean rci = false;

		/**
		 * RCIの期間を保持します。
		 */
		public int rciPeriod = 9;

		/**
		 * RCI の売りシグナルの閾値を保持します。
		 */
		public int rciUpperSignal = 80;

		/**
		 * RCI の買いシグナルの閾値を保持します。
		 */
		public int rciLowerSignal = -80;

		// ---------------------------------------- ROC

		/**
		 * ROC を表示するかどうかを保持します。
		 */
		public boolean roc = false;

		/**
		 * ROC の期間を保持します。
		 */
		public int rocPeriod = 25;

		// ---------------------------------------- 強弱レシオ(篠原レシオ)

		/**
		 * 強弱レシオ(篠原レシオ)を表示するかどうかを保持します。
		 */
		public boolean shinohara = false;

		/**
		 * 強弱レシオ(篠原レシオ)の期間を保持します。
		 */
		public int shinoharaPeriod = 26;

		// ---------------------------------------- ストキャスティクス

		/**
		 * ストキャスティクスを表示するかどうかを保持します。
		 */
		public boolean srv = false;

		/**
		 * ストキャスティクスの%K期間を保持します。
		 */
		public int srvKPeriod = 9;

		/**
		 * ストキャスティクスの%D期間を保持します。
		 */
		public int srvDPeriod = 3;

		/**
		 * ストキャスティクスの売りシグナルの閾値を保持します。
		 */
		public int srvUpperSignal = 70;

		/**
		 * ストキャスティクスの買いシグナルの閾値を保持します。
		 */
		public int srvLowerSignal = 30;

		// ---------------------------------------- TII

		public boolean tii = false;
		public MAType tii_matype = MAType.SMA;
		public int tii_period = 30;
		public int tii_upper_signal = 80;
		public int tii_lower_signal = 20;

		// ---------------------------------------- トリックス(Trix)

		/**
		 * トリックス(Trix)を表示するかどうかを保持します。
		 */
		public boolean trix = false;

		/**
		 * トリックス(Trix)の期間を保持します。
		 */
		public int trixPeriod = 25;

		/**
		 * トリックス(Trix)シグナルで使用する移動平均の種類を保持します。
		 */
		public MAType trixSignalMaType = MAType.SMA;

		/**
		 * トリックス(Trix)のシグナルの期間を保持します。
		 */
		public int trixSignalPeriod = 9;

		// ---------------------------------------- TSI

		public boolean tsi = false;
		public int tsi_period1 = 13;
		public int tsi_period2 = 25;
		public MAType tsi_signal_matype = MAType.SMA;
		public int tsi_signal_period = 7;
		public int tsi_upper_signal = +25;
		public int tsi_lower_signal = -25;

		// ---------------------------------------- 究極のオシレーター

		/**
		 * 究極のオシレーターを表示するかどうかを保持します。
		 */
		public boolean ultimate = false;

		/**
		 * 究極のオシレーターの期間を保持します。
		 */
		public int ultimatePeriod = 7;

		// ---------------------------------------- ウイリアムズAD

		/**
		 * ウイリアムズADを表示するかどうかを保持します。
		 */
		public boolean wad = false;

		// ---------------------------------------- ウイリアムズ%R

		/**
		 * ウイリアムズ%Rを表示するかどうかを保持します。
		 */
		public boolean williamsR = false;

		/**
		 * ウイリアムズ%Rの期間を保持します。
		 */
		public int williamsRPeriod = 20;

		/**
		 * ウイリアムズ%Rの売りシグナルの閾値を保持します。
		 */
		public int williamsRUpperSignal = -20;

		/**
		 * ウイリアムズ%Rの買いシグナルの閾値を保持します。
		 */
		public int williamsRLowerSignal = -80;

		// ---------------------------------------- レシオケーター

		/**
		 * レシオケーターを表示するかどうかを保持します。
		 */
		public boolean ratiocater = false;

		// ---------------------------------------- 出来高

		/**
		 * 出来高分析指標の種類を保持します。
		 */
		public VolumeType volumeType = VolumeType.MARGIN;

		/**
		 * 出来高移動平均線で使用する移動平均の種類を保持します。
		 */
		public MAType vmaMaType = MAType.EMA;

		/**
		 * 出来高移動平均1の期間を保持します。
		 */
		public int vma1Period = 25;

		/**
		 * 出来高移動平均2の期間を保持します。
		 */
		public int vma2Period = 75;

		public Color volumeColor1 = Color.GREEN;
		public Color volumeColor2 = ChartColor.DARK_GREEN;

		// ---------------------------------------- A/Dライン

		/**
		 * A/Dラインを表示するかどうかを保持します。
		 */
		public boolean ad = false;

		// ---------------------------------------- チャイキンズA/Dオシレーター

		public boolean cho = false;
		public MAType cho_matype = MAType.EMA;
		public int cho_fast = 3;
		public int cho_slow = 10;

		// ---------------------------------------- 出来高乖離率

		/**
		 * 出来高乖離率を表示するかどうかを保持します。
		 */
		public boolean vkairi = false;

		/**
		 * 出来高乖離率で使用する移動平均の種類を保持します。
		 */
		public MAType vbiasMaType = MAType.SMA;

		/**
		 * 出来高乖離率の期間を保持します。
		 */
		public int vbiasPeriod = 25;

		// ---------------------------------------- ボリューム・オシレータ(AVO)

		/**
		 * ボリューム・オシレータ(AVO)を表示するかどうかを保持します。
		 */
		public boolean avo = false;

		/**
		 * ボリューム・オシレータ(AVO)の期間1を保持します。
		 */
		public int avoMa1Period = 10;

		/**
		 * ボリューム・オシレータ(AVO)の期間2を保持します。
		 */
		public int avoMa2Period = 30;

		// ---------------------------------------- ボリューム・オシレータ(PVO)

		/**
		 * ボリューム・オシレータ(PVO)を表示するかどうかを保持します。
		 */
		public boolean pvo = false;

		/**
		 * ボリューム・オシレータ(PVO)の期間1を保持します。
		 */
		public int pvoMa1Period = 10;

		/**
		 * ボリューム・オシレータ(PVO)の期間2を保持します。
		 */
		public int pvoMa2Period = 30;

		// ---------------------------------------- V-ROC

		/**
		 * V-ROC を表示するかどうかを保持します。
		 */
		public boolean vroc = false;

		/**
		 * V-ROC の期間を保持します。
		 */
		public int vrocPeriod = 10;

		// ---------------------------------------- VR1

		/**
		 * ボリュームレシオ1を表示するかどうかを保持します。
		 */
		public boolean vr1 = false;

		/**
		 * ボリュームレシオ1の期間を保持します。
		 */
		public int vr1Period = 25;

		/**
		 * ボリュームレシオ1の売りシグナルの閾値を保持します。
		 */
		public int vr1UpperSignal = 450;

		/**
		 * ボリュームレシオ1の買いシグナルの閾値を保持します。
		 */
		public int vr1LowerSignal = 70;

		// ---------------------------------------- VR2

		/**
		 * ボリュームレシオ2を表示するかどうかを保持します。
		 */
		public boolean vr2 = false;

		/**
		 * ボリュームレシオ2の期間を保持します。
		 */
		public int vr2Period = 14;

		/**
		 * ボリュームレシオ2の売りシグナルの閾値を保持します。
		 */
		public int vr2UpperSignal = 70;

		/**
		 * ボリュームレシオ2の買いシグナルの閾値を保持します。
		 */
		public int vr2LowerSignal = 30;

		// ---------------------------------------- V-RSI

		/**
		 * V-RSI を表示するかどうかを保持します。
		 */
		public boolean vrsi = false;

		/**
		 * V-RSI の期間を保持します。
		 */
		public int vrsiPeriod = 14;

		/**
		 * V-RSI の売りシグナルの閾値を保持します。
		 */
		public int vrsiUpperSignal = 75;

		/**
		 * V-RSI の買いシグナルの閾値を保持します。
		 */
		public int vrsiLowerSignal = 25;

		// ---------------------------------------- WVR

		/**
		 * 和光ボリュームレシオを表示するかどうかを保持します。
		 */
		public boolean wvr = false;

		/**
		 * 和光ボリュームレシオの期間を保持します。
		 */
		public int wvrPeriod = 25;

		/**
		 * 和光ボリュームレシオの売りシグナルの閾値を保持します。
		 */
		public int wvrUpperSignal = 60;

		/**
		 * 和光ボリュームレシオの買いシグナルの閾値を保持します。
		 */
		public int wvrLowerSignal = -60;

		// ---------------------------------------- PVI

		public boolean pvi = false;
		public MAType pvi_matype = MAType.EMA;
		public int pvi_fast = 9;
		public int pvi_slow = 25;

		// ---------------------------------------- NVI

		public boolean nvi = false;
		public MAType nvi_matype = MAType.EMA;
		public int nvi_fast = 9;
		public int nvi_slow = 25;

		// ---------------------------------------- OBV

		/**
		 * OBV を表示するかどうかを保持します。
		 */
		public boolean obv = false;

		/**
		 * OBV の期間を保持します。
		 */
		public int obvPeriod = 75;

		// ---------------------------------------- PVT

		public boolean pvt = false;

		// ---------------------------------------- 価格帯別出来高

		/**
		 * 価格帯別出来高を表示するかどうかを保持します。
		 */
		public boolean vp = false;

		/**
		 * 価格帯の数を保持します。
		 */
		public int vpCount = 20;

		// ---------------------------------------- 信用倍率

		/**
		 * 信用倍率を表示するかどうかを保持します。
		 */
		public boolean ratio = false;

		/**
		 * 信用倍率の売りシグナルの閾値を保持します。
		 */
		public double ratioUpperSignal = 10;

		/**
		 * 信用倍率の買いシグナルの閾値を保持します。
		 */
		public double ratioLowerSignal = 1;

		// ---------------------------------------- 騰落価格

		/**
		 * 騰落価格を表示するかどうかを保持します。
		 */
		public boolean price_performance = false;

		/**
		 * 騰落価格の基準期間を保持します。
		 */
		public PeriodType priceFluctuationsPeriodType = PeriodType.ALL;

		// ---------------------------------------- 騰落率

		/**
		 * 騰落率を表示するかどうかを保持します。
		 */
		public boolean percent_performance = false;

		/**
		 * 騰落率の基準期間を保持します。
		 */
		public PeriodType performancePeriodType = PeriodType.ALL;

	}

	/**
	 * 価格チャートの設定情報を保持します。
	 */
	public final TimeSeriesSettings timeSeries = new TimeSeriesSettings();

	// ---------------------------------------- ポイント＆フィギュア

	/**
	 * ポイント＆フィギュアチャートの設定情報を提供します。
	 */
	public static final class PointFigureSettings {

		/**
		 * 範囲に0を含めるかどうかを保持します。
		 */
		public boolean fixed = false;

		/**
		 * ポイント(%)を保持します。
		 */
		public int point = 2;

		/**
		 * 転換ルールを保持します。
		 */
		public int reversal = 3;
	}

	/**
	 * ポイント＆フィギュアチャートの設定情報を保持します。
	 */
	public final PointFigureSettings pf = new PointFigureSettings();

	// ---------------------------------------- カギ足

	/**
	 * カギ足チャートの設定情報を提供します。
	 */
	public static final class KagiSettings {

		/**
		 * 範囲に0を含めるかどうかを保持します。
		 */
		public boolean fixed = false;

		/**
		 * 定率を保持します。
		 */
		public int rate = 3;

	}

	/**
	 * カギ足チャートの設定情報を保持します。
	 */
	public final KagiSettings kagi = new KagiSettings();

	// ---------------------------------------- 練行足

	/**
	 * 練行足チャートの設定情報を提供します。
	 */
	public static final class RenkohSettings {

		/**
		 * 範囲に0を含めるかどうかを保持します。
		 */
		public boolean fixed = false;

		/**
		 * 値幅(定率)を保持します。
		 */
		public int rate = 3;

	}

	/**
	 * 練行足チャートの設定情報を保持します。
	 */
	public final RenkohSettings renkoh = new RenkohSettings();

	// ---------------------------------------- 新値足

	/**
	 * 新値足チャートの設定情報を提供します。
	 */
	public static final class ShinneSettings {

		/**
		 * 範囲に0を含めるかどうかを保持します。
		 */
		public boolean fixed = false;

		/**
		 * 転換ルールを保持します。
		 */
		public int reversal = 3;
	}

	/**
	 * 新値足チャートの設定情報を保持します。
	 */
	public final ShinneSettings shinne = new ShinneSettings();

	// ---------------------------------------- 逆ウォッチ曲線

	/**
	 * 逆ウォッチ曲線チャートの設定情報を提供します。
	 */
	public static final class AntiWatchSettings {

		/**
		 * 範囲に0を含めるかどうかを保持します。
		 */
		public boolean fixed = false;

		/**
		 * ガイドを表示するかどうかを保持します。
		 */
		public boolean signalMarker = true;

		/**
		 * 移動平均の種類を保持します。
		 */
		public MAType maType = MAType.SMA;

		/**
		 * 移動平均の期間を保持します。
		 */
		public int maPeriod = 25;

	}

	/**
	 * 逆ウォッチ曲線チャートの設定情報を保持します。
	 */
	public final AntiWatchSettings antiwatch = new AntiWatchSettings();

}
