/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.axis;

import java.awt.Color;
import java.io.Serializable;

/**
 * 領域マーカーを提供します。
 * 
 * @author 杉澤 浩二
 */
public class IntervalMarker implements Marker, Serializable {

	private static final long serialVersionUID = 500904330483741032L;

	/**
	 * 下限値を保持します。
	 */
	private Number lower;

	/**
	 * 上限値を保持します。
	 */
	private Number upper;

	/**
	 * 色を保持します。
	 */
	private Color color;

	/**
	 * デフォルトコンストラクタです。
	 */
	protected IntervalMarker() {}

	/**
	 * コンストラクタです。
	 * 
	 * @param upper 上限値
	 * @param lower 下限値
	 * @param color 色
	 */
	public IntervalMarker(final Number upper, final Number lower, final Color color) {
		this.lower = lower;
		this.upper = upper;
		this.color = color;
	}

	/**
	 * 下限値を返します。
	 * 
	 * @return 下限値
	 */
	public Number getLower() { return lower; }

	/**
	 * 上限値を返します。
	 * 
	 * @return 上限値
	 */
	public Number getUpper() { return upper; }

	/**
	 * 色を返します。
	 * 
	 * @return 色
	 */
	public Color getColor() { return color; }

}
