/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.axis;

import java.io.Serializable;

import jp.sf.orangesignal.ta.util.Assert;

/**
 * 数値の範囲情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public class Range implements Serializable {

	private static final long serialVersionUID = 8406468739567876279L;

	/**
	 * 下限値を保持します。
	 */
	private double lower;

	/**
	 * 上限値を保持します。
	 */
	private double upper;

	/**
	 * デフォルトコンストラクタです。
	 */
	protected Range() {}

	/**
	 * コンストラクタです。
	 * 
	 * @param lower 下限値
	 * @param upper 上限値
	 */
	public Range(final double lower, final double upper) {
		Assert.isFalse(lower > upper);
		this.lower = lower;
		this.upper = upper;
	}

	/**
	 * 下限値を返します。
	 * 
	 * @return 下限値
	 */
	public double getLower() { return lower; }

	/**
	 * 上限値を返します。
	 * 
	 * @return 上限値
	 */
	public double getUpper() { return upper; }

	/**
	 * 範囲を返します。
	 * 
	 * @return 範囲
	 */
	public double getLength() { return this.upper - this.lower; }

}
