/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.axis;

import java.awt.Color;
import java.io.Serializable;

/**
 * 基準線マーカーを提供します。
 * 
 * @author 杉澤 浩二
 */
public class ValueMarker implements Marker, Serializable {

	private static final long serialVersionUID = -4540145547682427541L;

	/**
	 * 基準値を保持します。
	 */
	private double value;

	/**
	 * 色を保持します。
	 */
	private Color color;

	/**
	 * コンストラクタです。
	 * 
	 * @param value 基準値
	 * @param color 色
	 */
	public ValueMarker(double value, final Color color) {
		this.value = value;
		this.color = color;
	}

	/**
	 * 基準値を返します。
	 * 
	 * @return 基準値
	 */
	public double getValue() { return value; }

	/**
	 * 色を返します。
	 * 
	 * @return 色
	 */
	public Color getColor() { return color; }

}
