/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.data;

import java.util.Date;

import jp.sf.orangesignal.chart.ChartSettings.AntiWatchSettings;
import jp.sf.orangesignal.ta.util.ArrayUtils;

/**
 * 逆ウォッチ曲線データセットを返します。
 * 
 * @author 杉澤 浩二
 */
public class AntiWatchChartDataset implements ChartDataset {

	/**
	 * 日付の配列を保持します。
	 */
	public Date[] date;

	/**
	 * 株価移動平均のリストを保持します。
	 */
	public Number[] ma;

	/**
	 * 出来高移動平均のリストを保持します。
	 */
	public Number[] vma;

	/**
	 * コンストラクタです。
	 * 
	 * @param dataset データセット
	 * @param settings 設定情報
	 */
	public AntiWatchChartDataset(final BasicChartDataset dataset, final AntiWatchSettings settings) {
		final int period = settings.maPeriod;
		if (dataset.getCount() >= period) {
			this.date = ArrayUtils.subarray(dataset.date, period);
			this.ma = ArrayUtils.subarray(settings.maType.calculate(dataset.techClose, period), period);
			this.vma = ArrayUtils.subarray(settings.maType.calculate(dataset.techVolume, period), period);
		}
	}

	@Override public int getCount() { return this.date == null ? 0 : this.date.length; }

}
