/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui;

import jp.sf.orangesignal.chart.util.StringManager;

/**
 * チャート画面の種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum ChartScreenType {

	/**
	 * (なし)を表します。
	 */
	NONE { @Override public String toString() { return StringManager.getString("screen.none"); } },

	/**
	 * 時系列画面を表します。
	 */
	TIME_SERIES { @Override public String toString() { return StringManager.getString("screen.timeseries"); } },

	/**
	 * ポイント＆フィギュア画面を表します。
	 */
	POINT_AND_FIGURE { @Override public String toString() { return StringManager.getString("screen.p&f"); } },

	/**
	 * カギ足画面を表します。
	 */
	KAGI { @Override public String toString() { return StringManager.getString("screen.kagi"); } },

	/**
	 * 練行足(練り足)画面を表します。
	 */
	RENKOH { @Override public String toString() { return StringManager.getString("screen.renkoh"); } },

	/**
	 * 新値足画面を表します。
	 */
	SHINNE { @Override public String toString() { return StringManager.getString("screen.shinne"); } },

	/**
	 * 逆ウォッチ曲線画面を表します。
	 */
	ANTI_WATCH { @Override public String toString() { return StringManager.getString("screen.antiwatch"); } },

	/**
	 * 履歴データ画面を表します。
	 */
	HISTORICAL_DATA { @Override public String toString() { return StringManager.getString("screen.history"); } };

}
