/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui;

import jp.sf.orangesignal.chart.util.StringManager;

/**
 * 足単位を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum DatasetType {

	/**
	 * 日足を表します。
	 */
	DAILY {
		@Override public String getChangeLabel() { return StringManager.getString("_change.daily"); }
		@Override public String toString() { return StringManager.getString("daily"); }
	},

	/**
	 * 週足を表します。
	 */
	WEEKLY {
		@Override public String getChangeLabel() { return StringManager.getString("_change.weekly"); }
		@Override public String toString() { return StringManager.getString("weekly"); }
	},

	/**
	 * 月足を表します。
	 */
	MONTHLY {
		@Override public String getChangeLabel() { return StringManager.getString("_change.monthly"); }
		@Override public String toString() { return StringManager.getString("monthly"); }
	};

	/**
	 * 前日比用の見出し文字列を返します。
	 * 
	 * @return 前日比用の見出し文字列
	 */
	public abstract String getChangeLabel();

}
