/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui.screen;

import java.awt.Canvas;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.ChartScreenEvent;
import jp.sf.orangesignal.chart.ui.Icons;

/**
 * 履歴サイド画面を提供します。
 * 
 * @author 杉澤 浩二
 */
public class HistoricalDataSideScreen extends SideScreen {

	private static final long serialVersionUID = 8052487340357325482L;

//	/**
//	 * プラットフォームが Mac OS X かどうかを保持します。
//	 */
//	private static final boolean mac = System.getProperty("mrj.version") != null;

	/**
	 * コンストラクタです。
	 * 
	 * @param icons アイコン情報
	 */
	public HistoricalDataSideScreen(final Icons icons) {
		final Canvas canvas = new Canvas();

		// レイアウトを処理します。
		final GridBagLayout layout = new GridBagLayout();
		setLayout(layout);

		addCanvas(layout, new GridBagConstraints(), 0, canvas);
	}

	/**
	 * この実装は何も行いません。
	 */
	@Override public void load(final ChartSettings settings) {}

	/**
	 * この実装は何も行いません。
	 */
	@Override public void save(final ChartSettings settings) {}

	/**
	 * この実装は何も行いません。
	 */
	@Override public void datasetSwitch(final ChartEvent e) {}

	/**
	 * この実装は何も行いません。
	 */
	@Override public void periodSwitch(final ChartEvent e) {}

	/**
	 * この実装は何も行いません。
	 */
	@Override public void settingChanged(final ChartEvent e) {}

	/**
	 * この実装は何も行いません。
	 */
	@Override public void positionChanged(final ChartScreenEvent e) {}

}
