/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data;

import java.io.Serializable;
import java.util.Locale;

import jp.sf.orangesignal.ta.util.Assert;

/**
 * 数値/通貨書式文字列情報を提供します。
 * 
 * @author 杉澤 浩二
 * @since 2.1
 */
public class NumberFormatConfig implements Serializable {

	private static final long serialVersionUID = -8985855766613481773L;

	/**
	 * デフォルトコンストラクタです。
	 */
	protected NumberFormatConfig() {}

	/**
	 * コンストラクタです。
	 * 
	 * @param pattern 数値/通貨書式文字列
	 * @param locale 地域情報
	 * @param currencyCode 通貨コード (ISO 4217 コード)
	 */
	public NumberFormatConfig(final String pattern, final Locale locale, final String currencyCode) {
		Assert.notEmpty(pattern, "Pattern must not be empty");
		this.pattern = pattern;
		this.locale = locale;
		this.currencyCode = currencyCode;
	}

	/**
	 * 数値/通貨書式文字列を保持します。
	 */
	private String pattern;

	/**
	 * 数値/通貨書式文字列を返します。
	 * 
	 * @return 数値/通貨書式文字列
	 */
	public String getPattern() { return pattern; }

	/**
	 * 地域情報を保持します。
	 */
	private Locale locale;

	/**
	 * 地域情報を返します。
	 * 
	 * @return 地域情報
	 */
	public Locale getLocale() { return locale; }

	/**
	 * 通貨コード (ISO 4217 コード) を保持します。
	 */
	private String currencyCode;

	/**
	 * 通貨コード (ISO 4217 コード) を返します。
	 * 
	 * @return 通貨コード (ISO 4217 コード)
	 */
	public String getCurrencyCode() { return currencyCode; }

}
